<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Detail Pembayaran</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    :root {
      --main-orange: #ff7700;
    }
    body {
      background-color: #ffffff;
      padding: 2rem 1rem 5rem;
    }
    .navbar {
      background-color: var(--main-orange);
    }
    .navbar-brand {
      color: white;
      font-weight: bold;
      font-size: 12px;
    }
    .info-box {
      background-color: #f8f9fa;
      border-radius: 10px;
      padding: 1.5rem;
      margin-bottom: 2rem;
    }
    .label {
      font-weight: 500;
      color: #444;
    }
    .value {
      font-weight: 600;
      color: #000;
    }
    .btn-kwitansi {
      background-color: var(--main-orange);
      color: white;
      border: none;
      padding: 0.75rem 1.5rem;
      font-size: 1rem;
      border-radius: 10px;
    }
    .btn-kwitansi:hover {
      background-color: #e86600;
    }
  </style>
</head>
<body>
<!-- Navbar -->
  <nav class="navbar shadow-sm bg-gradient">
    <div class="container-fluid d-flex align-items-center">
      <img src="<?=base_url()?>img/logo.png" alt="Logo" style="height: 40px; margin-right: 10px;">
      <span class="navbar-brand mb-0 h5 text-sm"><?=COMPANY_NAME?></span>
    </div>
  </nav>
  <div class="container">
    <!-- Judul -->
    <h4 class="fw-bold mt-2 mb-4">Detail Pembayaran</h4>

    <!-- Info Detail -->
    <div class="info-box shadow-sm">
      <div class="mb-2">
        <span class="label">Nomor Transaksi:</span><br>
        <span class="value"><?=$transaksi['kode']?></span>
      </div>
      <div class="mb-2">
        <span class="label">Tanggal:</span><br>
        <span class="value"><?=date("d M Y", strtotime($transaksi['tanggal']))?></span>
      </div>
      <div class="mb-2">
        <span class="label">Periode:</span><br>
        <span class="value"><?=$transaksi['periode']?></span>
      </div>
      <div class="mb-2">
        <span class="label">Nominal:</span><br>
        <span class="value">Rp <?=number_format($transaksi['total_akhir'],0,".",",")?></span>
      </div>
      <div class="mb-2">
        <span class="label">Status:</span><br>

        <?php
            if($transaksi['flag_validasi']=='2'):
          ?>
          <span class="badge bg-success">Completed</span>
          <?php
            elseif($transaksi['flag_validasi']=='1'):
          ?>
          <span class="badge bg-warning">Pending</span>
          <?php
            elseif($transaksi['flag_validasi']=='3'):
          ?>
          <span class="badge bg-danger">Canceled</span>
          <?php
            else:
          ?>
          <span class="badge bg-warning">Draft</span><span>Silahkan hubungi operator untuk informasi status</span>
          <?php
          endif;
          ?>
      </div>
    </div>

    <!-- Tombol Download -->
    <div id="downloadSection">
        <?php
            if($transaksi['flag_validasi']=='2'):
          ?>
      <button class="btn btn-kwitansi" onclick="downloadKwitansi()">
        Download Kwitansi
      </button>
      <?php endif; ?>
    </div>
  </div>

  <script>
    function downloadKwitansi() {
      // Ganti URL berikut sesuai path file PDF atau endpoint generator dari server
      const transaksiID = '<?=$transaksi['id_struk']?>';
      window.open(`<?=base_url()?>vwarga/cetakstruk/${transaksiID}`, '_blank');
    }
  </script>

</body>
</html>
