<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Terima Kasih</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    :root {
      --main-orange: #ff7700;
    }
    body {
      background-color: #ffffff;
      text-align: center;
      padding: 3rem 1rem;
    }
    .check-icon {
      font-size: 4rem;
      color: var(--main-orange);
      margin-bottom: 1rem;
    }
    .info-box {
      background-color: #f8f9fa;
      border-radius: 10px;
      padding: 1.5rem;
      margin: 1.5rem 0;
      text-align: left;
    }
    .btn-home {
      background-color: var(--main-orange);
      color: white;
      border: none;
      padding: 0.75rem 2rem;
      font-size: 1rem;
      border-radius: 10px;
    }
    .btn-home:hover {
      background-color: #e86600;
    }
  </style>
</head>
<body>

  <!-- Judul -->
  <h2 class="fw-bold mb-4">Terima Kasih</h2>

  <!-- Ikon Check Besar -->
  <div class="check-icon">
    <i class="bi bi-check-circle-fill"></i>
  </div>

  <!-- Informasi Transaksi -->
  <div class="container">
    <div class="info-box shadow-sm">
      <p><strong>Nomor Transaksi :</strong> <?=$nomor_transaksi?></p>
      <p><strong>Tanggal :</strong> <?=$tanggal?></p>
      <p><strong>Nominal :</strong> Rp. <?=number_format($nominal,0,".",",")?></p>
      <p><strong>Status :</strong> <span class="badge bg-warning text-dark">Pending</span></p>
    </div>

    <!-- Tombol ke Beranda -->
    <button class="btn btn-home mt-3" onclick="window.location.href='<?=base_url()?>vwarga/dashboard'">
      Kembali ke Halaman Utama
    </button>
  </div>

</body>
</html>
