<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Pembayaran</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="<?=base_url()?>assets/plugins/jquery/jquery.js"></script>
  <style>
    :root {
      --main-orange: #ff7700;
    }
    body {
      background-color: #ffffff;
      padding-bottom: 100px; /* space for sticky footer */
    }

    .navbar {
      background-color: var(--main-orange);
    }
    .navbar-brand {
      color: white;
      font-weight: bold;
      font-size: 12px;
    }

    .sticky-footer {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background-color: white;
      border-top: 1px solid #ddd;
      padding: 1rem;
      box-shadow: 0 -2px 10px rgba(0,0,0,0.05);
      z-index: 999;
    }
    .btn-next {
      background-color: var(--main-orange);
      color: white;
      border: none;
      width: 100%;
    }
    .btn-next:hover {
      background-color: #e86600;
    }
  </style>
</head>
<body>
    <!-- Navbar -->
  <nav class="navbar shadow-sm bg-gradient">
    <div class="container-fluid d-flex align-items-center">
      <img src="<?=base_url()?>img/logo.png" alt="Logo" style="height: 40px; margin-right: 10px;">
      <span class="navbar-brand mb-0 h5 text-sm"><?=COMPANY_NAME?></span>
    </div>
  </nav>

  <div class="container" style="padding-bottom: 50px;">
    <!-- Judul Halaman -->
    <h4 class="fw-bold mb-3">Pembayaran</h4>

    <!-- Info Pengisian -->
    <div class="alert alert-warning">
      Silakan pilih periode yang ingin Anda bayar. Total akan dihitung otomatis.
    </div>

    <!-- List Periode -->
    <form id="paymentForm" method="post" enctype="multipart/form-data">
      <div class="list-group">
        <?php
        foreach($invoices as $invoice):
        ?>
        <label class="list-group-item d-flex justify-content-between align-items-center">
          <div>
            <input class="form-check-input me-2 item-checkbox" name="input_check[]" type="checkbox" value="<?=$invoice['id_invoice']?>" data-nominal="<?=$invoice['nominal_akhir']?>" />
            <?php
            $tanggal = $invoice['tahun'].'-'.$invoice['bulan'].'-01';
            echo date("M Y", strtotime($tanggal));
            ?>
          </div>
          <span>Rp <?=number_format($invoice['nominal_akhir'],0,',','.')?></span>
        </label>
        <?php
        endforeach;
        ?>
        <!-- Tambahkan lebih banyak item jika diperlukan -->
      </div>
    </form>
  </div>

  <!-- Sticky Footer -->
  <div class="sticky-footer d-flex flex-column gap-3 px-3">
    <div>
      <div class="text-muted small">Total Iuran:</div>
      <div class="fw-bold" id="totalDisplay">Rp 0</div>
    </div>
    <button id="btn_next" class="btn btn-next">Next</button>
  </div>

<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<script>
const checkboxes = document.querySelectorAll('.item-checkbox');
const totalDisplay = document.getElementById('totalDisplay');

function formatRupiah(number) {
    return new Intl.NumberFormat("id-ID", { style: "currency", currency: "IDR" }).format(number);
}

function updateTotal() {
    let total = 0;
    checkboxes.forEach(cb => {
    if (cb.checked) {
        var nominal = parseInt(cb.getAttribute("data-nominal"));
        total += parseInt(nominal);
    }
    });
    totalDisplay.textContent = formatRupiah(total);
}

checkboxes.forEach(cb => {
    cb.addEventListener('change', updateTotal);
});
</script>

<script>
$(document).ready(function() {
    $("#btn_next").click(function() {
        $("#paymentForm").submit();
    });

    $("#paymentForm").submit(function (e) {
        e.preventDefault();
        Swal.fire({
            text: 'Menyimpan data.. Silahkan tunggu..',
            allowOutsideClick: false
        });
        Swal.showLoading();
        var data_kirim = $("#paymentForm").serialize();

        $.post("<?=base_url()?>vwarga/saveinvoice",data_kirim).done(function (data) {
            if (data.status == 'success')
            {
                window.location.href = '<?=base_url()?>vwarga/pembayaran_info';
            }
        }).fail(function (data) {
            if(data.statusText == 'input'){
                Swal.fire({
                    text:'Silahkan pilih dulu periode yang akan dibayarkan..',
                    icon : 'error'
                });
            }else{
                Swal.fire({
                    text:'Terjadi kesalahan sistem!',
                    icon : 'error'
                });
            }
        });
    });
});
</script>
</body>
</html>
