<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Penerimaan Harian</title>
    <style>
        @page {
            margin: 8mm 8mm 8mm 8mm;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 8px;
            margin: 0px;
        }

        h2 {
            text-align: center;
            margin-bottom: 10px;
        }

        .header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }

        .header-left {
            text-align: left;
        }

        .header-right {
            text-align: right;
            font-size: 9px;
        }

        .info-table {
            width: 100%;
            margin-bottom: 20px;
        }

        table.tabel {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 25px;
        }

        table.tabel th, table.tabel td {
            border: 1px solid #000;
            padding: 4px;
            word-break: break-word;
            vertical-align: top;
            font-size: 8px;
        }

        th {
            background-color: #f0f0f0;
            font-weight: bold;
            text-align: center;
        }

        .total-row {
            font-weight: bold;
            background-color: #e0e0e0;
        }
    </style>
</head>
<body>

    <div class="header">
        <div class="header-left">
            <strong><?= $company_name ?></strong><br>
            No. Laporan: <?= $no_laporan ?><br>
            Tanggal Laporan: <?= $tanggal_penerimaan ?><br>
            Tanggal Generate: <?= $tanggal_cetak ?><br>
        </div>
    </div>

    <h2>Laporan Penerimaan Harian</h2>
    <?php
    $grand_total_nominal = 0;
    $grand_total_diskon = 0;
    $grand_total_subtotal = 0;
    ?>
    <!-- Tabel Transaksi Non Kolektor -->
    <h4>Transaksi Kantor</h4>
    <table class="tabel">
        <thead>
            <tr>
                <th width="4%">No</th>
                <th width="5%">Grup</th>
                <th>Kwitansi</th>
                <th width="10%">Rumah</th>
                <th>Pemilik</th>
                <th width="20%">Alamat</th>
                <th>Jenis Bayar</th>
                <th>Operator</th>
                <th width="10%">Nominal</th>
                <th width="10%">Diskon</th>
                <th width="10%">Subtotal</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $total_nominal_kantor = 0;
            $total_diskon_kantor = 0;
            $total_subtotal_kantor = 0;
            foreach ($transaksi['kantor'] as $i => $row): ?>
            <tr>
                <td align="center"><?= $i + 1 ?></td>
                <td align="center"><?= $row['grup'] ?></td>
                <td><?= $row['no_kwitansi'] ?></td>
                <td align="center"><?= $row['kode_kk'] ?></td>
                <td><?= $row['nama_pemilik'] ?></td>
                <td><?= strlen($row['alamat']) > 50 ? substr($row['alamat'], 0, 50) . '...' : $row['alamat'] ?></td>
                <td><?= $row['jenis_pembayaran'] ?></td>
                <td><?= $row['nama_operator'] ?></td>
                <td align="right"><?= number_format($row['nominal'], 0, ',', '.') ?></td>
                <td align="right"><?= number_format($row['diskon'], 0, ',', '.') ?></td>
                <td align="right"><?= number_format($row['subtotal'], 0, ',', '.') ?></td>
            </tr>
            <?php 
                $total_nominal_kantor += $row['nominal'];
                $total_diskon_kantor += $row['diskon'];
                $total_subtotal_kantor += $row['subtotal'];
            endforeach; 
            ?>
            <tr class="total-row">
                <td colspan="8" align="right">Total</td>
                <td align="right"><?= number_format($total_nominal_kantor, 0, ',', '.') ?></td>
                <td align="right"><?= number_format($total_diskon_kantor, 0, ',', '.') ?></td>
                <td align="right"><?= number_format($total_subtotal_kantor, 0, ',', '.') ?></td>
            </tr>
        </tbody>
    </table>

    <!-- Tabel Transaksi Non Kolektor -->
    <h4>Transaksi Kolektor</h4>
    <table class="tabel">
        <thead>
            <tr>
                <th width="4%">No</th>
                <th width="5%">Grup</th>
                <th>Kwitansi</th>
                <th width="10%">Rumah</th>
                <th>Pemilik</th>
                <th width="20%">Alamat</th>
                <th>Jenis Bayar</th>
                <th>Kolektor</th>
                <th width="10%">Nominal</th>
                <th width="10%">Diskon</th>
                <th width="10%">Subtotal</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $total_nominal_kolektor = 0;
            $total_diskon_kolektor = 0;
            $total_subtotal_kolektor = 0;
            foreach ($transaksi['kolektor'] as $i => $row): ?>
            <tr>
                <td align="center"><?= $i + 1 ?></td>
                <td align="center"><?= $row['grup'] ?></td>
                <td><?= $row['no_kwitansi'] ?></td>
                <td align="center"><?= $row['kode_kk'] ?></td>
                <td><?= $row['nama_pemilik'] ?></td>
                <td><?= strlen($row['alamat']) > 50 ? substr($row['alamat'], 0, 50) . '...' : $row['alamat'] ?></td>
                <td><?= $row['jenis_pembayaran'] ?></td>
                <td><?= $row['nama_kolektor'] ?></td>
                <td align="right"><?= number_format($row['nominal'], 0, ',', '.') ?></td>
                <td align="right"><?= number_format($row['diskon'], 0, ',', '.') ?></td>
                <td align="right"><?= number_format($row['subtotal'], 0, ',', '.') ?></td>
            </tr>
            <?php 
                $total_nominal_kolektor += $row['nominal'];
                $total_diskon_kolektor += $row['diskon'];
                $total_subtotal_kolektor += $row['subtotal'];
            endforeach; ?>
            <tr class="total-row">
                <td colspan="8" align="right">Total</td>
                <td align="right"><?= number_format($total_nominal_kolektor, 0, ',', '.') ?></td>
                <td align="right"><?= number_format($total_diskon_kolektor, 0, ',', '.') ?></td>
                <td align="right"><?= number_format($total_subtotal_kolektor, 0, ',', '.') ?></td>
            </tr>
        </tbody>
    </table>
    <hr/>
    <table>
        <tr>
            <td>Total Penerimaan Sebelum Diskon</td>
            <td>:</td>
            <td align="right"><b>Rp. <?= number_format($total_nominal_kantor + $total_nominal_kolektor, 0, ',', '.') ?></b></td>
        </tr>
        <tr>
            <td>Total Diskon</td>
            <td>:</td>
            <td align="right"><b>Rp. <?= number_format($total_diskon_kantor + $total_diskon_kolektor, 0, ',', '.') ?></b></td>
        </tr>
        <tr>
            <td>Total Penerimaan</td>
            <td>:</td>
            <td align="right"><b>Rp. <?= number_format($total_subtotal_kantor + $total_subtotal_kolektor, 0, ',', '.') ?></b></td>
        </tr>
    </table>
    <hr/>
    <table style="margin-top:10px; font-size:10px;width:100%;">
        <tr>
            <td style="width: 30%;" align="center">Disetujui Oleh</td>
            <td style="width: 30%;" align="center">Dibuat Oleh</td>
            <td style="width: 30%;" align="center">Diperiksa Oleh</td>
        </tr>
        <tr>
            <td colspan="3"><div style="height: 40px;"></div></td>
        </tr>
        <tr>
            <td align="center">(<?=$voucher_disetujui?>)</td>
            <td align="center">(<?=$pembuat?>)</td>
            <td align="center">(<?=$voucher_diperiksa?>)</td>
        </tr>
    </table>
</body>
</html>
