<!doctype html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Comp Pay</title>
    <!--begin::Primary Meta Tags-->
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="title" content="Comp Pay" />
    <meta name="author" content="Format Teknologi" />
    <?= $this->include('layout/css/main') ?>
    <?= $this->include('layout/js/main_top') ?>

    <?= $this->include('layout/css/sweetalert') ?>
    <?= $this->include('layout/js/sweetalert') ?>
</head>
<body class="layout-fixed sidebar-expand-lg bg-white">
    <div class="app-wrapper">
        <?= $this->include('layout/navbar') ?>
        <?= $this->include('layout/sidebar') ?>
        <main class="app-main">
            <div class="app-content-header">
                <div class="container-fluid">
                    <?= $this->renderSection('page_title') ?>
                </div>
            </div>

            <div class="app-content">
                <div class="container-fluid">
                    <?= $this->renderSection('content') ?>

                    <?= $this->renderSection('page_script') ?>
                </div>
            </div>
        </main>
        <footer class="app-footer">
            <!--begin::To the end-->
            <div class="float-end d-none d-sm-inline">V 1.0</div>
            <!--end::To the end-->
            <!--begin::Copyright-->
            <strong>
            Copyright &copy; 2025
            <a href="#" class="text-decoration-none">Comp Pay</a>.
            </strong>
            <!--end::Copyright-->
        </footer>
        <?= $this->include('layout/js/main_bottom') ?>
        <script>
            $(document).ready(function () {
                // Fungsi cek notifikasi
                function cekNotifikasiBaru() {
                    $.ajax({
                        url: '<?=base_url()?>notifikasi/unnotif', // Ganti sesuai routing di CI4 kamu
                        method: 'GET',
                        dataType: 'json',
                        success: function (response) {
                            if (response.success && response.count > 0) {
                                response.data.forEach(function (notif) {
                                    Swal.fire({
                                        toast: true,
                                        position: 'top-end',
                                        icon: 'info',
                                        html: `
                                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                                <div style="flex-grow:1;">
                                                    <strong>${notif.judul}</strong><br>
                                                    <small>${notif.pesan}</small>
                                                </div>
                                                <button id="swal-close-btn" style="
                                                    background: none;
                                                    border: none;
                                                    font-weight: bold;
                                                    font-size: 1rem;
                                                    margin-left: 10px;
                                                    cursor: pointer;
                                                    color: #555;
                                                ">&times;</button>
                                            </div>
                                        `,
                                        showConfirmButton: false,
                                        timer: 20000,
                                        timerProgressBar: true,
                                        iconColor: 'white',
                                        customClass: {
                                            popup: 'swal2-toast-custom'
                                        },
                                        didOpen: (toast) => {
                                            document.getElementById('swal-close-btn').addEventListener('click', () => {
                                                Swal.close();
                                            });
                                            toast.addEventListener('click', (e) => {
                                                if (e.target.id !== 'swal-close-btn') {
                                                    window.location.href = ('<?=base_url()?>' + notif.link) || '#';
                                                }
                                            });
                                        }
                                    });
                                });
                            }

                            setTimeout(cekNotifikasiBaru, 15000);
                        },
                        error: function () {
                            console.error("Gagal mengambil notifikasi.");
                        }
                    });
                }
                // Cek notifikasi setiap 15 detik
                setTimeout(cekNotifikasiBaru, 15000);

                function cekUnreadCount() {
                    $.ajax({
                        url: '<?=base_url()?>notifikasi/unreadcount', // Ganti sesuai routing di CI4 kamu
                        method: 'GET',
                        dataType: 'json',
                        success: function (response) {
                            if (response.success && response.count > 0) {
                                $("#lonceng_notif").html(response.count);
                            }

                            setTimeout(cekUnreadCount, 15000);
                        },
                        error: function () {
                            console.error("Gagal mengambil notifikasi.");
                        }
                    });
                }

                cekUnreadCount();
                setTimeout(cekUnreadCount, 15000);

                function getNotifContent(){
                    $.ajax({
                        url: '<?=base_url()?>notifikasi/unreadcontent', // Ganti sesuai routing di CI4 kamu
                        method: 'GET',
                        dataType: 'json',
                        success: function (response) {
                            if (response.success && response.count > 0) {
                                $("#isi_notifikasi").html(response.content);
                            }else{
                                $("#isi_notifikasi").html("No Notification..");
                            }
                        },
                        error: function () {
                            console.error("Gagal mengambil notifikasi.");
                        }
                    });
                }

                $("#lonceng").click(function() {
                    $("#isi_notifikasi").html("Loading notif...");
                    getNotifContent();
                });

                $("#refresh_notif_content").click(function(e) {
                    e.preventDefault();
                    $("#isi_notifikasi").html("Loading notif...");
                    getNotifContent();
                });

                $('#isi_notifikasi').on('click', '.dropdown-item-notif', function(e) {
                    e.preventDefault();
                    var id = $(this).data("id");
                    var link = $(this).data("link");
                    $.ajax({
                        url: '<?=base_url()?>notifikasi/setnotifread', // Ganti sesuai routing di CI4 kamu
                        method: 'POST',
                        data:{id:id},
                        dataType: 'json',
                        success: function (response) {
                            if (response.success) {
                                document.location.href=link;
                            }
                        },
                        error: function () {
                            console.error("Gagal mengambil notifikasi.");
                        }
                    });
                });
            });
        </script>
    </div>
</body>
</html>