<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row">
    <div class="col-sm-6"><h3 class="mb-0">Transaksi</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item active" aria-current="page">Pembatalan</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-2">
    <div class="col-lg-3">
        <div class="info-box">
            <div class="info-box-content">
                <span class="info-box-text">Transaksi Canceled</span>
                <span class="info-box-number"><?=$total_canceled?></span>
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-12">
        <table id="tbl1" class="table table-bordered table-sm nowrap">
            <thead>
                <tr>
                    <th>No.</th>
                    <th class="dt-filterable">Kode</th>
                    <th class="dt-filterable">Grup</th>
                    <th class="dt-filterable">Tanggal</th>
                    <th class="dt-filterable">Total Awal</th>
                    <th class="dt-filterable">Diskon</th>
                    <th class="dt-filterable">Total Akhir</th>
                    <th class="dt-filterable">Jenis Pembayaran</th>
                    <th class="dt-filterable">Tgl. Pembayaran</th>
                    <th class="dt-filterable">Pembayar</th>
                    <th class="dt-filterable">No. Telp</th>
                    <th class="dt-filterable">Operator</th>
                    <th class="dt-filterable">Kolektor</th>
                    <th class="dt-filterable">Batal</th>
                    <th class="dt-filterable">Status</th>
                    <th class="dt-filterable">Tgl Status</th>
                    <th class="dt-filterable">Keterangan</th>
                    <th class="dt-filterable">Created At</th>
                    <th class="dt-filterable">Updated At</th>
                    <th class="dt-filterable">Updater</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/js/datatables') ?>

<script type="text/javascript">
$(document).ready(function () {
    var table1 = $("#tbl1").DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        lengthMenu: [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
        pageLength:50,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'Bfrtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>kolektor/transaksi/ajax_dt_pembatalan',
            type : 'POST'
        },
        columns: [
            { data: null,
                 width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'kode' },
            { data: 'nama_grup_transaksi' },
            { data: 'tanggal' },
            { data: 'total', render: DataTable.render.number(",",".",2) },
            { data: 'total_diskon', render: DataTable.render.number(",",".",2) },
            { data: 'total_akhir', render: DataTable.render.number(",",".",2) },
            { data: 'jenis_pembayaran' },
            { data: 'tanggal_pembayaran' },
            { data: 'pembayar' },
            { data: 'no_telp' },
            { data: 'nama_operator' },
            { data: 'nama_kolektor' },
            { data: 'status_batal' },
            { data: 'status_validasi' },
            { data: 'tanggal_validasi' },
            { data: 'keterangan_validasi' },
            { data: 'created_at' },
            { data: 'updated_at' },
            { data: 'updated_username' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 20,
                data: null,
                defaultContent: '<button class="btn-view btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> View</button>',
            },
        ],
        buttons: [
            'pageLength',
            'searchBuilder',
            {
                text: '<span class="fas fa-plus"> Add New</span>',
                action: function ( e, dt, node, config ) {
                    document.location.href="<?=base_url()?>kolektor/transaksi/add";
                }
            },
            'copyHtml5',
            {
                extend: 'excelHtml5',
                text: 'Export Excel',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'csvHtml5',
                text: 'Export CSV',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'pdfHtml5',
                text: 'Export PDF',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            }
        ],
        "initComplete": function(settings, json) {
        }
    });

    table1.on( 'draw.dt', function () {
        var PageInfo = $('#tbl1').DataTable().page.info();
        table1.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#tbl1 tbody').on('click','.btn-view',function () {
        var data = table1.row($(this).parents('tr')[0]).data();
        document.location.href='<?=base_url()?>kolektor/transaksi/view_pembatalan/'+data['id_transaksi'];
    });
});
</script>
<?= $this->endSection() ?>