<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Transaksi</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>kolektor/transaksi">Transaksi Pembayaran</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>kolektor/transaksi/view/<?=$transaksi->id_transaksi?>">Transaksi Pembayaran</a></li>
        <li class="breadcrumb-item active" aria-current="page">Add Rumah</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>kolektor/transaksi/view/<?=$transaksi->id_transaksi?>" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-6">
        <div class="card card-warning card-outline mb-4">
            <div class="card-header">
                <div class="card-title">Header Transaksi</div>
            </div>
            <div class="card-body p-0">
                <table class="table">
                    <tbody>
                        <tr>
                            <td>Kode:</td>
                            <td><?=$transaksi->kode?></td>
                        </tr>
                        <tr>
                            <td>Grup Transaksi:</td>
                            <td><?=$transaksi->nama_grup_transaksi?></td>
                        </tr>
                        <tr>
                            <td>Kolektor:</td>
                            <td><?=$transaksi->kolektor_username?></td>
                        </tr>
                        <tr>
                            <td>Operator:</td>
                            <td><?=$transaksi->operator_username?></td>
                        </tr>
                        <tr>
                            <td>Tanggal:</td>
                            <td><?=$transaksi->tanggal?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>      
    </div>

    <div class="col-lg-6">
        <div class="card card-warning card-outline mb-4">
            <div class="card-header">
                <div class="card-title">Rumah</div>
            </div>
            <div class="card-body p-0">
                <table class="table">
                    <tbody>
                        <tr>
                            <td>Kode:</td>
                            <td><?=$kk->kode?></td>
                        </tr>
                        <tr>
                            <td>Pemilik:</td>
                            <td><?=$kk->nama_pemilik?></td>
                        </tr>
                        <tr>
                            <td>Alamat:</td>
                            <td><?=$kk->alamat?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>      
    </div>
</div>

<div class="row">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Tagihan</div>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Tahun</th>
                            <th>Bulan</th>
                            <th>Nominal</th>
                            <th>Diskon</th>
                            <th>Sub Total</th>
                            <th>Pilihan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <form name="f1" id="f1" method="post" action="#" enctype="multipart/form-data">
                        <?php
                        foreach($invoice as $item):
                        ?>
                        <tr>
                            <td><?=$item["tahun"]?></td>
                            <td><?=$item["bulan"]?></td>
                            <td><?=number_format($item["nominal"],2,".",",")?></td>
                            <td><?=number_format($item["nominal_diskon"],2,".",",")?></td>
                            <td><?=number_format($item["nominal_akhir"],2,".",",")?></td>
                            <td>
                                <?php
                                if(!empty($item["id_invoice"])):
                                ?>
                                    <?php
                                    if(($transaksi->flag_batal=='0') && ($transaksi->flag_validasi<=1)):
                                    ?>
                                    <input type="checkbox" name="check_iuran[]" class="iuran_check" data-nominal="<?=$item["nominal"]?>" data-diskon="<?=$item["nominal_diskon"]?>" data-akhir="<?=$item["nominal_akhir"]?>" data-invoice="<?=$item["id_invoice"]?>" value="<?=$item["id_invoice"]?>" <?=$item['checked']?>>
                                    <?php
                                    endif;
                                    ?>
                                <?php
                                else:
                                ?>
                                    <?=$item['status']?>
                                <?php
                                endif;
                                ?>
                            </td>
                        </tr>
                        <?php 
                        endforeach; 
                        ?>
                        </form>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Rincian</div>
            </div>
            <div class="card-body p-0">
                <table class="table">
                    <tbody>
                        <tr>
                            <td>Total Awal : </td>
                            <td><span id="sub_total"></span></td>
                        </tr>
                        <tr>
                            <td>Diskon : </td>
                            <td><span id="diskon"></span></td>
                        </tr>
                        <tr>
                            <td>Total : </td>
                            <td><h4><span id="total"></span></h4></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="card-footer">
                <div class="text-end">
                    <?php
                    if(($transaksi->flag_batal=='0') && ($transaksi->flag_validasi<=1)):
                    ?>
                    <a href="#" id="b_proses" class="btn btn-primary">Simpan</a>
                    <?php
                    endif;
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<?php
if(($transaksi->flag_batal=='0') && ($transaksi->flag_validasi<=1)):
?>
<script type="text/javascript">
$(document).ready(function() {

$("#b_proses").click(function () {
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();
    
    var data_kirim = $("#f1").serializeArray();
    data_kirim.push({name:"id_transaksi",value:"<?=$transaksi->id_transaksi?>"});
    data_kirim.push({name:"id_kk",value:"<?=$kk->id_kk?>"});
    var final_data = $.param(data_kirim);

    $.ajax({
        url : "<?=base_url()?>kolektor/transaksi/update_detail",
        type:'POST',
        data : final_data
    }).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Transaksi berhasil disimpan!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>kolektor/transaksi/view/' + data.id_transaksi;
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});

});
</script>
<?php
endif;
?>

<script>
var total = <?=$total?>;
var total_diskon = <?=$total_diskon?>;
var total_akhir = <?=$total_akhir?>;

$(".iuran_check").on("click",function(e){
    if(e.target.checked){
        total = total + parseInt(e.target.dataset.nominal);
        total_diskon = total_diskon + parseInt(e.target.dataset.diskon);
        total_akhir = total_akhir + parseInt(e.target.dataset.akhir);
    }else{
        total = total - parseInt(e.target.dataset.nominal);
        total_diskon = total_diskon - parseInt(e.target.dataset.diskon);
        total_akhir = total_akhir - parseInt(e.target.dataset.akhir);
        if(total < 0){
            total = 0;
        }

        if(total_diskon < 0){
            total_diskon = 0;
        }

        if(total_akhir < 0){
            total_akhir = 0;
        }
    }

    $("#sub_total").html(formatRupiah(total));
    $("#diskon").html(formatRupiah(total_diskon));
    $("#total").html(formatRupiah(total_akhir));
});

function formatRupiah(angka) {
  let number_string = angka.toString().replace(/[^,\d]/g, ''),
      split = number_string.split(','),
      sisa = split[0].length % 3,
      rupiah = split[0].substr(0, sisa),
      ribuan = split[0].substr(sisa).match(/\d{3}/gi);

  if (ribuan) {
    let separator = sisa ? '.' : '';
    rupiah += separator + ribuan.join('.');
  }

  rupiah = split[1] !== undefined ? rupiah + ',' + split[1] : rupiah;
  return 'Rp ' + rupiah;
}

$("#sub_total").html(formatRupiah('<?=$total?>'));
$("#diskon").html(formatRupiah('<?=$total_diskon?>'));
$("#total").html(formatRupiah('<?=$total_akhir?>'));
</script>
<?= $this->endSection() ?>