<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Transaksi</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>transaksi">Transaksi Pembayaran</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>transaksi/view/<?=$transaksi->id_transaksi?>">Transaksi Pembayaran</a></li>
        <li class="breadcrumb-item active" aria-current="page">Add Pembayaran</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>transaksi/view/<?=$transaksi->id_transaksi?>" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-6">
        <div class="card card-warning card-outline mb-4">
            <div class="card-header">
                <div class="card-title">Header Transaksi</div>
            </div>
            <div class="card-body p-0">
                <table class="table">
                    <tbody>
                        <tr>
                            <td>Kode:</td>
                            <td><?=$transaksi->kode?></td>
                        </tr>
                        <tr>
                            <td>Grup Transaksi:</td>
                            <td><?=$transaksi->nama_grup_transaksi?></td>
                        </tr>
                        <tr>
                            <td>Kolektor:</td>
                            <td><?=$transaksi->kolektor_username?></td>
                        </tr>
                        <tr>
                            <td>Operator:</td>
                            <td><?=$transaksi->operator_username?></td>
                        </tr>
                        <tr>
                            <td>Tanggal:</td>
                            <td><?=$transaksi->tanggal?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>      
    </div>

    <div class="col-lg-6">
        <div class="card card-warning card-outline mb-4">
            <div class="card-header">
                <div class="card-title">Rumah</div>
            </div>
            <div class="card-body p-0">
                <table class="table">
                    <tbody>
                        <tr>
                            <td>Kode:</td>
                            <td><?=$kk->kode?></td>
                        </tr>
                        <tr>
                            <td>Pemilik:</td>
                            <td><?=$kk->nama_pemilik?></td>
                        </tr>
                        <tr>
                            <td>Alamat:</td>
                            <td><?=$kk->alamat?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>      
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Tagihan</div>
            </div>
            <div class="card-body">
                <form name="f1" id="f1" method="post" action="#" enctype="multipart/form-data">
                    <div class="row mb-3">
                        <label for="start_periode" class="col-sm-3 col-form-label">Periode Mulai : </label>
                        <div class="col-sm-9 d-flex align-items-center">
                            <input type="month" name="start_periode" class="form-control" value="<?=$start_periode?>">
                        </div>
                        <div id="estart_periode" class="text-danger invalid-feedback text-end"></div>
                    </div>
                    <div class="row mb-3">
                        <label for="start_periode" class="col-sm-3 col-form-label">Periode Akhir : </label>
                        <div class="col-sm-9 d-flex align-items-center">
                            <input type="month" name="end_periode" class="form-control" value="<?=$end_periode?>">
                        </div>
                        <div id="estart_periode" class="text-danger invalid-feedback text-end"></div>
                    </div>
                </form>
            </div>
            <div class="card-footer d-flex">
                <?php
                if(($transaksi->flag_batal=='0') && ($transaksi->flag_validasi<=1)):
                ?>
                <a href="#" id="b_proses" class="btn btn-primary">Simpan</a>
                <?php
                endif;
                ?>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<?php
if(($transaksi->flag_batal=='0') && ($transaksi->flag_validasi<=1)):
?>
<script type="text/javascript">
$(document).ready(function() {

$("#b_proses").click(function () {
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();
    
    var data_kirim = $("#f1").serializeArray();
    data_kirim.push({name:"id_transaksi",value:"<?=$transaksi->id_transaksi?>"});
    data_kirim.push({name:"id_kk",value:"<?=$kk->id_kk?>"});
    var final_data = $.param(data_kirim);

    $.ajax({
        url : "<?=base_url()?>transaksi/update_detail_simple",
        type:'POST',
        data : final_data
    }).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Transaksi berhasil disimpan!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>transaksi/view/' + data.id_transaksi;
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            if(data.responseJSON.messages.error){
                Swal.fire({
                    text:data.responseJSON.messages.error,
                    icon : 'error'
                });
            }else{
                Swal.fire({
                    text:'Terjadi kesalahan sistem!',
                    icon : 'error'
                });
            }
        }
    });
});

});
</script>
<?php
endif;
?>
<?= $this->endSection() ?>