<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Jalan dan Blok</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>jalan">Jalan dan Blok</a></li>
        <li class="breadcrumb-item active" aria-current="page">View</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>jalan" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
        <a href="#" id="btn_delete" class="btn btn-sm btn-danger btn-icon"><i class="button-icon bi bi-trash"></i> <span>Delete Data</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-8">
        <form name="f1" id="f1" action="<?=base_url()?>jalan/save_add" method="post" enctype="multipart/form-data">
            <div class="card card-warning card-outline mb-4">
                <div class="card-header">
                    <div class="card-title">Detail</div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <label for="kode" class="col-sm-2 col-form-label">Kode Jalan : </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" id="kode" name="kode" value="<?=$data->kode?>">
                            <span id="ekode" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="nama" class="col-sm-2 col-form-label">Nama Jalan : </label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" id="nama" name="nama" value="<?=$data->nama?>">
                            <span id="enama" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="keterangan" class="col-sm-2 col-form-label">Keterangan : </label>
                        <div class="col-sm-10">
                            <textarea class="form-control" id="keterangan" name="keterangan"><?=$data->keterangan?></textarea>
                            <span id="enama" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex">
                    <button type="submit" class="btn btn-primary">Update</button>
                    <button type="reset" class="btn btn-warning ml-auto">Cancel</button>
                </div>
            </div>
        </form>        
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-12">
        <b>Blok</b>
        <table id="tbl1" class="table table-bordered table-sm nowrap">
            <thead>
                <tr>
                    <th>No.</th>
                    <th class="dt-filterable">Kode</th>
                    <th class="dt-filterable">Nama</th>
                    <th class="dt-filterable">Keterangan</th>
                    <th class="dt-filterable">Created At</th>
                    <th class="dt-filterable">Updated At</th>
                    <th class="dt-filterable">Updater</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>
<?= $this->include('layout/js/datatables') ?>

<script type="text/javascript">
$(document).ready(function() {

$("#f1").submit(function (e) {
    e.preventDefault();
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();
    var data_kirim = $("#f1").serializeArray();
    data_kirim.push({name : "id", value : "<?=$data->id_jalan?>"});

    $.post("<?=base_url()?>jalan/update",data_kirim).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Data baru berhasil disimpan!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>jalan/view/' + <?=$data->id_jalan?>;
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});

$("#btn_delete").click(function(e) {
    e.preventDefault();

    Swal.fire({
        title:'Delete Data..',
        html: '<p>Yakin ingin menghapus data ini?</p>',
        showDenyButton: true,
        showCancelButton: true,
        confirmButtonText: 'Yes',
        denyButtonText: 'No',
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                text: 'Menghapus data.. Silahkan tunggu..',
                allowOutsideClick: false
            });
            Swal.showLoading();
            $.post("<?=base_url()?>jalan/delete",{id:<?=$data->id_jalan?>}).done(function (data) {
                if (data.status == 'success')
                {
                    Swal.fire({
                        text:'Data berhasil dihapus!',
                        icon : 'success'
                    }).then(function () {
                        window.location.href = '<?=base_url()?>jalan';
                    });
                }
            }).fail(function (data) {
                Swal.fire({
                    text:'Terjadi kesalahan pada saat operasi delete!',
                    icon : 'error'
                });
            });
        } else if (result.isDenied) {
            Swal.fire('Operasi dibatalkan..', '', 'info')
        }
    });
});

    var table1 = $("#tbl1").DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        lengthMenu: [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
        pageLength:50,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'Bfrtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>jalan/ajax_dt_blok/<?=$data->id_jalan?>',
            type : 'POST'
        },
        columns: [
            { data: null,
                 width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'kode' },
            { data: 'nama' },
            { data: 'keterangan' },
            { data: 'created_at' },
            { data: 'updated_at' },
            { data: 'updated_username' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 7,
                data: null,
                defaultContent: '<button class="btn-view btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> View</button>',
            },
        ],
        buttons: [
            'pageLength',
            'searchBuilder',
            {
                text: '<span class="fas fa-plus"> Add New</span>',
                action: function ( e, dt, node, config ) {
                    document.location.href="<?=base_url()?>jalan/add_blok/<?=$data->id_jalan?>";
                }
            },
            'copyHtml5',
            {
                extend: 'excelHtml5',
                text: 'Export Excel',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'csvHtml5',
                text: 'Export CSV',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'pdfHtml5',
                text: 'Export PDF',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            }
        ],
        "initComplete": function(settings, json) {
        }
    });

    table1.on( 'draw.dt', function () {
        var PageInfo = $('#tbl1').DataTable().page.info();
        table1.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#tbl1 tbody').on('click','.btn-view',function () {
        var data = table1.row($(this).parents('tr')[0]).data();
        document.location.href='<?=base_url()?>jalan/view_blok/'+data['id_blok'];
    });

});
</script>
<?= $this->endSection() ?>