<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row">
    <div class="col-sm-6"><h3 class="mb-0">Iuran</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item active" aria-current="page">Iuran</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row g-4">
    <div class="col-lg-12">
        <table id="tbl1" class="table table-bordered table-sm nowrap">
            <thead>
                <tr>
                    <th>No.</th>
                    <th class="dt-filterable">Grup Pembayaran</th>
                    <th class="dt-filterable">Jenis</th>
                    <th class="dt-filterable">Nominal</th>
                    <th class="dt-filterable">Start Date</th>
                    <th class="dt-filterable">End Date</th>
                    <th class="dt-filterable">Status</th>
                    <th class="dt-filterable">Created At</th>
                    <th class="dt-filterable">Updated At</th>
                    <th class="dt-filterable">Updater</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/js/datatables') ?>

<script type="text/javascript">
$(document).ready(function () {
    var table1 = $("#tbl1").DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        lengthMenu: [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
        pageLength:50,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'Bfrtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>iuran/ajax_dt',
            type : 'POST'
        },
        columns: [
            { data: null,
                 width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'nama_grup_transaksi' },
            { data: 'nama_jenis_kk' },
            { data: 'nominal', render: DataTable.render.number(",",".",2) },
            { data: 'start_date' },
            { data: 'end_date' },
            { data: 'status' },
            { data: 'created_at' },
            { data: 'updated_at' },
            { data: 'updated_username' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 10,
                data: null,
                defaultContent: '<button class="btn-view btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> View</button>',
            },
        ],
        buttons: [
            'pageLength',
            'searchBuilder',
            {
                text: '<span class="fas fa-plus"> Add New</span>',
                action: function ( e, dt, node, config ) {
                    document.location.href="<?=base_url()?>iuran/add";
                }
            },
            'copyHtml5',
            {
                extend: 'excelHtml5',
                text: 'Export Excel',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'csvHtml5',
                text: 'Export CSV',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'pdfHtml5',
                text: 'Export PDF',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            }
        ],
        "initComplete": function(settings, json) {
        }
    });

    table1.on( 'draw.dt', function () {
        var PageInfo = $('#tbl1').DataTable().page.info();
        table1.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#tbl1 tbody').on('click','.btn-view',function () {
        var data = table1.row($(this).parents('tr')[0]).data();
        document.location.href='<?=base_url()?>iuran/view/'+data['id_iuran'];
    });
});
</script>
<?= $this->endSection() ?>