<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row">
    <div class="col-sm-6"><h3 class="mb-0">Open Invoice</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item active" aria-current="page">Open Invoice</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body d-flex justify-content-end gap-3">
                <?php
                if(($user->group == 'admin') || ($user->group == 'operator')) :
                ?>
                <a href="<?=base_url()?>invoice/generate_invoice" class="btn btn-primary">Generate Invoice</a>
                <?php endif; ?>
                <a href="<?=base_url()?>invoice/cetak_invoice_open" class="btn btn-primary">Cetak Open Invoice</a>
            </div>
        </div>
    </div>
</div>
<div class="row mb-2">
    <div class="col-lg-3">
        <div class="info-box">
            <div class="info-box-content">
                <span class="info-box-text">Jumlah KK</span>
                <span class="info-box-number"><?=$total_kk?></span>
            </div>
        </div>
    </div>
    <div class="col-lg-3">
        <div class="info-box">
            <div class="info-box-content">
                <span class="info-box-text">Jumlah Open Invoice</span>
                <span class="info-box-number"><?=$total_open_invoice?></span>
            </div>
        </div>
    </div>
</div>
<div class="row g-4">
    <div class="col-lg-12">
        <table id="tbl1" class="table table-bordered table-sm nowrap">
            <thead>
                <tr>
                    <th>No.</th>
                    <th class="dt-filterable">Pembayaran</th>
                    <th class="dt-filterable">Nomor</th>
                    <th class="dt-filterable">Periode</th>
                    <th class="dt-filterable">Kode KK</th>
                    <th class="dt-filterable">Nama Pemilik</th>
                    <th class="dt-filterable">Jalan</th>
                    <th class="dt-filterable">Blok</th>
                    <th class="dt-filterable">Nomor Rumah</th>
                    <th class="dt-filterable">Jenis</th>
                    <th class="dt-filterable">Area</th>
                    <th class="dt-filterable">Iuran</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/js/datatables') ?>

<script type="text/javascript">
$(document).ready(function () {
    var table1 = $("#tbl1").DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        lengthMenu: [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
        pageLength:50,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'Bfrtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>invoice/ajax_dt_open',
            type : 'POST'
        },
        columns: [
            { data: null,
                 width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'nama_grup_transaksi' },
            { data: 'nomor_invoice' },
            { data: 'periode' },
            { data: 'kode' },
            { data: 'nama_pemilik' },
            { data: 'nama_jalan' },
            { data: 'nama_blok' },
            { data: 'nomor_rumah' },
            { data: 'nama_jenis_kk' },
            { data: 'area' },
            { data: 'nominal_akhir', render: DataTable.render.number(",",".",2) },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 12,
                data: null,
                defaultContent: '<button class="btn-view btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> Cetak</button>',
            },
        ],
        buttons: [
            'pageLength',
            'searchBuilder',
            'copyHtml5',
            {
                extend: 'excelHtml5',
                text: 'Export Excel',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'csvHtml5',
                text: 'Export CSV',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'pdfHtml5',
                text: 'Export PDF',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            }
        ],
        "initComplete": function(settings, json) {
        }
    });

    table1.on( 'draw.dt', function () {
        var PageInfo = $('#tbl1').DataTable().page.info();
        table1.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#tbl1 tbody').on('click','.btn-view',function () {
        var data = table1.row($(this).parents('tr')[0]).data();
        var newwindow=window.open('<?=base_url()?>invoice/cetak_invoice/'+data['id_invoice'],'Invoice','height=500,width=500');
        newwindow.print();
        if (window.focus) {newwindow.focus()}
    });
});
</script>
<?= $this->endSection() ?>