<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Closed Invoice</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>invoice/closed">Closed Invoice</a></li>
        <li class="breadcrumb-item active" aria-current="page">Pembayaran</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>invoice/closed" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
        <a href="javascript:openPdfWindow()" class="btn btn-sm btn-primary btn-icon"><i class="button-icon bi bi-printer"></i> <span>Cetak Struk</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-6">
        <div class="card card-warning card-outline mb-4">
            <div class="card-header d-flex">
                <div class="card-title">Detail Pembayaran</div>
                <div class="card-tools ml-auto">
                    <button type="button" class="btn btn-tool" data-lte-toggle="card-collapse">
                    <i data-lte-icon="expand" class="bi bi-plus-lg"></i>
                    <i data-lte-icon="collapse" class="bi bi-dash-lg"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="grup_pembayaran" class="form-label">Grup Pembayaran</label>
                    <span class="form-control" id="grup_pembayaran"><?=$data->nama_grup_pembayaran?></span>
                </div>
                <div class="mb-3">
                    <label for="nomor" class="form-label">Nomor Invoice</label>
                    <span class="form-control" id="nomor"><?=$data->nomor?></span>
                </div>
                <div class="mb-3">
                    <label for="periode" class="form-label">Periode</label>
                    <span class="form-control" id="periode"><?=$data->periode?></span>
                </div>
                <div class="mb-3">
                    <label for="iuran" class="form-label">Iuran</label>
                    <span class="form-control" id="iuran"><?=number_format($data->biaya,2,",",".")?></span>
                </div>
                <hr/>
                <div class="mb-3">
                    <label for="pembayar" class="form-label">Nomor Struk :</label>
                    <span class="form-control" id="pembayar"><?=$data->nomor_struk?></span>
                </div>
                <div class="mb-3">
                    <label for="pembayar" class="form-label">Tanggal Bayar :</label>
                    <span class="form-control" id="pembayar"><?=$data->tanggal?></span>
                </div>
                <div class="mb-3">
                    <label for="pembayar" class="form-label">Nama Pembayar :</label>
                    <span class="form-control" id="pembayar"><?=$data->pembayar?></span>
                </div>
                <div class="mb-3">
                    <label for="pembayar" class="form-label">No. Telp :</label>
                    <span class="form-control" id="pembayar"><?=$data->no_telp?></span>
                </div>
                <div class="mb-3">
                    <label for="pembayar" class="form-label">Jenis Pembayaran :</label>
                    <span class="form-control" id="pembayar"><?=$data->jenis_pembayaran?></span>
                </div>
            </div>
            <div class="card-footer d-flex">
                
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card card-warning card-outline mb-4">
            <div class="card-header d-flex">
                <div class="card-title">Detail KK</div>
                <div class="card-tools ml-auto">
                    <button type="button" class="btn btn-tool" data-lte-toggle="card-collapse">
                    <i data-lte-icon="expand" class="bi bi-plus-lg"></i>
                    <i data-lte-icon="collapse" class="bi bi-dash-lg"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Kode KK</label>
                    <span class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"><?=$data->kode?></span>
                </div>
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Nama Pemilik</label>
                    <span class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"><?=$data->nama_pemilik?></span>
                </div>
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Jalan</label>
                    <span class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"><?=$data->jalan?></span>
                </div>
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Blok</label>
                    <span class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"><?=$data->blok?></span>
                </div>
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Nomor Rumah</label>
                    <span class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp"><?=$data->nomor_rumah?></span>
                </div>
            </div>
            <div class="card-footer d-flex">
                
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<script type="text/javascript">
$(document).ready(function() {

$("#f1").submit(function (e) {
    e.preventDefault();
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();

    var data_kirim = $("#f1").serializeArray();
    data_kirim.push({name : "id_invoice", value : "<?=$data->id_invoice?>"});

    $.post("<?=base_url()?>invoice/save_pembayaran",data_kirim).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Invoice berhasil di-update!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>invoice/view/<?=$data->id_invoice?>';
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});
});
</script>

<script>
function openPdfWindow() {
  window.open(
    '<?=base_url()?>invoice/cetak_struk/<?=$data->id_invoice?>',           // URL ke file PHP yang output PDF
    'Struk',                    // Nama window
    'width=800,height=600,resizable=yes,scrollbars=yes' // Parameter jendela
  );
}
</script>
<?= $this->endSection() ?>