<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Diskon</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>diskon">Diskon</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>diskon/detail/<?=$diskon->id_diskon?>">Detail</a></li>
        <li class="breadcrumb-item active" aria-current="page">View</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>diskon/detail/<?=$diskon->id_kk?>" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
        <a href="#" id="btn_delete" class="btn btn-sm btn-danger btn-icon"><i class="button-icon bi bi-trash"></i> <span>Delete Data</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-8">
        <form name="f1" id="f1" action="<?=base_url()?>diskon/update" method="post" enctype="multipart/form-data">
            <div class="card card-warning card-outline mb-4">
                <div class="card-header">
                    <div class="card-title">View</div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <label for="nominal" class="col-sm-3 col-form-label">Nominal : </label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="nominal" name="nominal" value="<?=$diskon->nominal?>">
                            <span id="enominal" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="start_date" class="col-sm-3 col-form-label">Tgl Mulai : </label>
                        <div class="col-sm-9">
                            <input type="date" class="form-control" id="start_date" name="start_date" value="<?=$diskon->start_date?>">
                            <span id="estart_date" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="end_date" class="col-sm-3 col-form-label">Tgl Akhir : </label>
                        <div class="col-sm-9">
                            <input type="date" class="form-control" id="end_date" name="end_date" value="<?=$diskon->end_date?>">
                            <span id="eend_date" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="keterangan" class="col-sm-3 col-form-label">Keterangan : </label>
                        <div class="col-sm-9">
                            <textarea class="form-control" id="keterangan" name="keterangan"><?=$diskon->keterangan?></textarea>
                            <span id="eketerangan" class="text-danger invalid-feedback"></span>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="reset" class="btn btn-warning ml-auto">Cancel</button>
                </div>
            </div>
        </form>        
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>
<?= $this->include('layout/js/jquerymask') ?>

<script type="text/javascript">
$(document).ready(function() {

$('#nominal').mask("#,##0.00", {reverse: true});

$("#f1").submit(function (e) {
    e.preventDefault();
    Swal.fire({
        text: 'Menyimpan data.. Silahkan tunggu..',
        allowOutsideClick: false
    });
    Swal.showLoading();
    $("#nominal").val($("#nominal").val().replace(",",""));
    var data_kirim = $("#f1").serializeArray();
    data_kirim.push({name : "id", value : "<?=$diskon->id_diskon?>"});

    $.post("<?=base_url()?>diskon/update",data_kirim).done(function (data) {
        if (data.status == 'success')
        {
            Swal.fire({
                text:'Update berhasil disimpan!',
                icon : 'success'
            }).then(function () {
                window.location.href = '<?=base_url()?>diskon/view/<?=$diskon->id_diskon?>';
            });
        }
    }).fail(function (data) {
        if(data.statusText == 'input'){
            Object.keys(data.responseJSON.messages).forEach(function(key){
                $("#e"+key).html(data.responseJSON.messages[key]);
                $("#e"+key).show();
            });
            Swal.close();
        }else{
            Swal.fire({
                text:'Terjadi kesalahan sistem!',
                icon : 'error'
            });
        }
    });
});

$("#btn_delete").click(function(e) {
    e.preventDefault();

    Swal.fire({
        title:'Delete Data..',
        html: '<p>Yakin ingin menghapus data ini?</p>',
        showDenyButton: true,
        showCancelButton: true,
        confirmButtonText: 'Yes',
        denyButtonText: 'No',
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                text: 'Menghapus data.. Silahkan tunggu..',
                allowOutsideClick: false
            });
            Swal.showLoading();
            $.post("<?=base_url()?>diskon/delete",{id:<?=$diskon->id_diskon?>}).done(function (data) {
                if (data.status == 'success')
                {
                    Swal.fire({
                        text:'Data berhasil dihapus!',
                        icon : 'success'
                    }).then(function () {
                        window.location.href = '<?=base_url()?>diskon/detail/<?=$diskon->id_kk?>';
                    });
                }
            }).fail(function (data) {
                Swal.fire({
                    text:'Terjadi kesalahan pada saat operasi delete!',
                    icon : 'error'
                });
            });
        } else if (result.isDenied) {
            Swal.fire('Operasi dibatalkan..', '', 'info')
        }
    });
});
});
</script>
<?= $this->endSection() ?>