<?= $this->extend('layout/main') ?>

<?= $this->section('page_title') ?>
<div class="row border-bottom">
    <div class="col-sm-6"><h3 class="mb-0">Diskon</h3></div>
    <div class="col-sm-6">
        <ol class="breadcrumb float-sm-end">
        <li class="breadcrumb-item"><a href="<?=base_url()?>">Home</a></li>
        <li class="breadcrumb-item"><a href="<?=base_url()?>diskon">Diskon</a></li>
        <li class="breadcrumb-item active" aria-current="page">Detail</li>
        </ol>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="row mb-3">
    <div class="col-lg-12 d-flex justify-content-end gap-2">
        <a href="<?=base_url()?>diskon" class="btn btn-sm btn-warning btn-icon"><i class="button-icon bi bi-arrow-left-circle"></i> <span>Kembali</span></a>
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-8">
        <div class="card card-warning card-outline mb-4">
            <div class="card-header">
                <div class="card-title">Data KK</div>
            </div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr>
                        <td>Kode KK :</td>
                        <td><?=$kk->kode?></td>
                    </tr>
                    <tr>
                        <td>Jenis KK :</td>
                        <td><?=$kk->nama_jenis_kk?></td>
                    </tr>
                    <tr>
                        <td>Nama Pemilik :</td>
                        <td><?=$kk->nama_pemilik?></td>
                    </tr>
                    <tr>
                        <td>Alamat :</td>
                        <td><?=$kk->jalan?>, <?=$kk->blok?>, No. <?=$kk->nomor_rumah?></td>
                    </tr>
                    <tr>
                        <td>Area :</td>
                        <td><?=$kk->area?></td>
                    </tr>
                    <tr>
                        <td>Keterangan :</td>
                        <td><?=$kk->keterangan?></td>
                    </tr>
                </table>
            </div>
        </div> 
    </div>
    <div class="col-lg-4">
        <div class="card card-warning card-outline mb-4">
            <div class="card-header">
                <div class="card-title">Diskon Aktif</div>
            </div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr>
                        <td>Diskon :</td>
                    </tr>
                    <tr>
                        <td align="right"><h4>Rp. <?=number_format($diskon_kk,2,".",",")?></h4></td>
                    </tr>
                </table>
            </div>
        </div> 
    </div>
</div>

<style>
    .greenRow td{
        background-color: greenyellow !important;
    }
</style>
<div class="row g-4">
    <div class="col-lg-12">
        <div class="card card-warning card-outline mb-4">
            <div class="card-header">
                <div class="card-title">Diskon</div>
            </div>
            <div class="card-body">
                <table id="tbl1" class="table table-bordered table-sm nowrap">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th class="dt-filterable">Nominal</th>
                            <th class="dt-filterable">Start Date</th>
                            <th class="dt-filterable">End Date</th>
                            <th class="dt-filterable">Keterangan</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div> 
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('page_script') ?>
<?= $this->include('layout/css/sweetalert') ?>
<?= $this->include('layout/js/sweetalert') ?>

<?= $this->include('layout/js/datatables') ?>

<script type="text/javascript">
$(document).ready(function() {
    var table1 = $("#tbl1").DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        lengthMenu: [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
        pageLength:50,
        responsive:false,
        order: [[1, 'asc']],
        dom: 'Bfrtip',
        language : {
            searchBuilder: {
                button: '<span class="fas fa-search"> Filter</span>',
                columns: [".dt-filterable"]
            }
        },
        ajax: {
            url : '<?=base_url()?>diskon/ajax_dt/<?=$kk->id_kk?>',
            type : 'POST'
        },
        columns: [
            { data: null,
                 width: '1%',
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
            { data: 'nominal', render: DataTable.render.number(",",".",2) },
            { data: 'start_date' },
            { data: 'end_date' },
            { data: 'keterangan' },
            { data: null,
                searchable : false,
                orderable : false,
            className: 'dt-center', targets: '_all' },
        ],
        columnDefs: [
            {
                targets: 5,
                data: null,
                defaultContent: '<button class="btn-view btn btn-block btn-success btn-sm"><span class="fas fa-search"></span> View</button>',
            },
        ],
        "createdRow": function( row, data, dataIndex){
            if( data.end_date ==  '9999-12-31'){
                $(row).addClass('greenRow');
            }
        },
        buttons: [
            'pageLength',
            'searchBuilder',
            {
                text: '<span class="fas fa-plus"> Add New</span>',
                action: function ( e, dt, node, config ) {
                    document.location.href="<?=base_url()?>diskon/add/<?=$kk->id_kk?>";
                }
            },
            'copyHtml5',
            {
                extend: 'excelHtml5',
                text: 'Export Excel',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'csvHtml5',
                text: 'Export CSV',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            },
            {
                extend: 'pdfHtml5',
                text: 'Export PDF',
                orientation: 'landscape',
                exportOptions: {
                    columns: [ ':not(.not-export)' ]
                }
            }
        ],
        "initComplete": function(settings, json) {
        }
    });

    table1.on( 'draw.dt', function () {
        var PageInfo = $('#tbl1').DataTable().page.info();
        table1.column(0, { page: 'current' }).nodes().each( function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

    $('#tbl1 tbody').on('click','.btn-view',function () {
        var data = table1.row($(this).parents('tr')[0]).data();
        document.location.href='<?=base_url()?>diskon/view/'+data['id_diskon'];
    });
});
</script>
<?= $this->endSection() ?>