<?php
namespace App\Libraries;

class GeneralLib{
    public function getProfilePic($data)
    {
        if (!isset($data) || ($data==null))
        {
            return base_url().'uploads/user_profile/profile.png';
        }else{
            return base_url().'uploads/user_profile/'.$data;
        }
    }

    public function dt_traverse_search_builder($node)
    {
        $query_array = array();
        $logic = $node['logic'];
        $child_query = "";
        $result_query = "";
        foreach($node['criteria'] as $item){
            if (isset($item['criteria']))
            {
                $child_query = $this->dt_traverse_search_builder($item);
                $query_array[] = $child_query;
            }elseif(isset($item['condition'])){
                if ($item['condition'] == 'starts')
                {
                    $query_array[] = $item['origData']." like '".$item['value1']."%'";
                }elseif($item['condition'] == '!starts')
                {
                    $query_array[] = $item['origData']." not like '".$item['value1']."%'";
                }elseif($item['condition'] == 'contains')
                {
                    $query_array[] = $item['origData']." like '%".$item['value1']."%'";
                }elseif($item['condition'] == '!contains')
                {
                    $query_array[] = $item['origData']." not like '%".$item['value1']."%'";
                }elseif($item['condition'] == 'ends')
                {
                    $query_array[] = $item['origData']." like '%".$item['value1']."'";
                }elseif($item['condition'] == '!ends')
                {
                    $query_array[] = $item['origData']." not like '%".$item['value1']."'";
                }elseif($item['condition'] == 'null')
                {
                    $query_array[] = $item['origData']." IS NULL or ".$item['origData']."=''";
                }elseif($item['condition'] == 'between')
                {
                    if(empty($item['value2'])){
                        $item['value2'] = $item['value1'];
                    }
                    $query_array[] = $item['origData']." between '".$item['value1']."' ".$logic."'".$item['value2']."'";
                }elseif($item['condition'] == '!between')
                {
                    if(empty($item['value2'])){
                        $item['value2'] = $item['value1'];
                    }
                    $query_array[] = $item['origData']." not between '".$item['value1']."' ".$logic."'".$item['value2']."'";
                }else{
                    $query_array[] = $item['origData']." ".$item['condition']." '".$item['value1']."'";
                }
            }
        }

        $result_query = implode(" ".$logic." ",$query_array);
        if(!empty($result_query)){
            $result_query = "(".$result_query.")";
        }
        return $result_query;
    }
}
?>