<?php
namespace App\Controllers\Operator;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use CodeIgniter\Shield\Entities\User;
use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\Usermodeloperator;

class Operator extends BaseController
{
    use ResponseTrait;

    private $user;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) 
    {
        parent::initController($request, $response, $logger);
        $this->user = service("user_data");
    }

    private function check_access(){
        $user = service("user_data");
        if($user->data->group != 'operator'){
            return false;
        }else{
            return true;
        }
    }

    public function profile() {
        $data['user'] = $this->user->data;
        $tmodel = new Usermodeloperator();
        $builder = $tmodel->builder();
        $data['data'] = $builder->where("id_operator",$data['user']->id_operator)->get()->getRow();
        if($data['data'] == null){
            return redirect()->to("kolektor");
        }
        return view('operator/profile/view',$data);
    }

    public function update_profile()
    {
        $data = array();
        $data['status'] = 'success';
        $data['user'] = $this->user->data;

        $id = $data['user']->id_operator;
        $request = [
            'nama' => $this->request->getPost('nama',FILTER_SANITIZE_ADD_SLASHES),
            'email' => $this->request->getPost('email',FILTER_SANITIZE_ADD_SLASHES),
            'password' => $this->request->getPost('password',FILTER_SANITIZE_ADD_SLASHES),
            'updated_by' => $this->user->data->id_auth
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('nama', 'Nama', 'required|is_unique[operator.nama,operator.id_operator,'.$id.']');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $adminmodel = new Usermodeloperator();
            $admin = $adminmodel->find($id);
            if($admin == null){
                return $this->fail(["error" => "Database Error!"],400,null,'db');
            }

            $user_provider = auth()->getProvider();
            $user = $user_provider->findById($admin->id_user);
            
            if($request['email'] != $admin->email){
                $user->setEmail($request['email']);
                if(!$user_provider->update($admin->id_user,$user)){
                    return $this->fail(['email' => "Email sudah digunakan!"],400,null,'input');
                }
            }

            if(!empty($request['password'])){
                $user->setPassword($request['password']);
                $user_provider->update($admin->id_user,$user);
            }

            $adminmodel = new Usermodeloperator();
            if ($adminmodel->update($id,$request))
            {
                return $this->respond($data,200);
            }else{
                return $this->fail(["error" => "Database Error!"],400,null,'db');
            }
        }
    }
}
?>