<?php
namespace App\Controllers;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\Jeniskkmodel;
use App\Models\Gruppembayaranmodel;
use App\Models\Iuranmodel;
use App\Models\Invoicemodel;
use App\Models\Kkmodel;
use App\Models\Strukmodel;
use App\Models\Tarifmodel;
use App\Models\Diskonmodel;

use Dompdf\Dompdf;
use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Label\Label;
use Endroid\QrCode\Logo\Logo;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;

class Invoice extends BaseController
{
    use ResponseTrait;

    public function cetak_invoice($id_invoice){
        $data = array();
        $data["company_name"] = "PT Anugerah Cemara Abadi";

        $invoicemodel = new Invoicemodel();
        $invoicemodel = $invoicemodel->builder("vinvoice");
        $invoicemodel->where("id_invoice",$id_invoice);
        $invoice = $invoicemodel->get()->getRow();

        if(is_null($invoice)){
            die("Invoice not available");
        }

        if($invoice->flag_close=='1'){
            $invoicemodel = new Invoicemodel();
            $invoicemodel = $invoicemodel->builder("vinvoiceclosed");
            $invoicemodel->where("id_invoice",$id_invoice);
            $invoice = $invoicemodel->get()->getRow();

            if(is_null($invoice)){
                die("Invoice not available");
            }
        }
        $data["tanggal"] = date("d M Y");
        if(isset($invoice->kode_transaksi)){
            $data["nomor_transaksi"] = $invoice->kode_transaksi;
        }
        $data["nomor_invoice"] = $invoice->nomor_invoice;
        $data['kode_rumah'] = $invoice->kode;
        $data['nama_pemilik'] = $invoice->nama_pemilik;
        $data['alamat'] = $invoice->nama_jalan.', '.$invoice->nama_blok.', No. '.$invoice->nomor_rumah;
        $data['nominal'] = $invoice->nominal_akhir;
        $data['status'] = $invoice->flag_close;
        $data['receiver'] = "";
        $data['operator'] = "";

        // ===== Data Transaksi ===== //
        $qr_text = base_url().'invoice/cetak_invoice/'.$invoice->id_invoice;

        // ===== Buat QR Code ===== //
        $writer = new PngWriter();
        $qrCode = new QrCode(
            data: $qr_text,
            encoding: new Encoding('UTF-8'),
            errorCorrectionLevel: ErrorCorrectionLevel::Low,
            size: 100,
            margin: 0,
            roundBlockSizeMode: RoundBlockSizeMode::Margin,
            foregroundColor: new Color(0, 0, 0),
            backgroundColor: new Color(255, 255, 255)
        );

        $result = $writer->write($qrCode);

        ob_start();
        $result->saveToFile('php://output');
        $imageData = ob_get_clean();
        $base64 = base64_encode($imageData);
        $imgSrc = 'data:image/png;base64,' . $base64;
        
        $data['qr_code'] = $imgSrc;
        $data["periode"] = $invoice->periode;

        $html = view('print/invoice', $data);

        while (ob_get_level()) {
            ob_end_clean();
        }
        $dompdf = new \Dompdf\Dompdf();
        $dompdf->loadHtml($html);
        $dompdf->setPaper([0, 0, 612, 312], 'portrait'); // 1/3 folio
        $dompdf->render();
        $dompdf->stream('invoice.pdf', ['Attachment' => false]);
    }
}
?>