<?php
namespace App\Controllers\Admin;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;

use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\Notifikasimodel;
use App\Models\Notifikasipenerimamodel;

class Notifikasi extends BaseController
{
    use ResponseTrait;

    private $user;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) 
    {
        parent::initController($request, $response, $logger);
        $this->user = service("user_data");
    }

    private function check_access(){
        $user = service("user_data");
        if($user->data->group != 'admin'){
            return false;
        }else{
            return true;
        }
    }

    public function index(){
        $data['user'] = $this->user->data;
        return view('admin/jalan/index',$data);
    }

    public function unnotif() {
        $data = array();
        $id = auth()->id();

        $notifikasiarray = array();
        $notifikasimodel = new Notifikasimodel();
        $notifikasibuilder = $notifikasimodel->builder("vnotifikasi");
        $notifikasis = $notifikasibuilder->get()->getResultArray();
        $count = 0;
        foreach($notifikasis as $notifikasi){
            $notifikasipenerimamodel = new Notifikasipenerimamodel();
            $notifikasipenerimabuilder = $notifikasipenerimamodel->builder();
            $notifikasipenerimabuilder->where("id_notifikasi",$notifikasi['id_notifikasi']);
            $notifikasipenerimabuilder->where("id_user",$id);
            $notifikasipenerima = $notifikasipenerimabuilder->selectCount("id_notifikasi_penerima","jumlah_notif")->get()->getRow();
            if($notifikasipenerima->jumlah_notif == 0){
                $notifikasiarray[$count]['id_notifikasi'] = $notifikasi["id_notifikasi"];
                $notifikasiarray[$count]['judul'] = $notifikasi["judul"];
                $notifikasiarray[$count]['pesan'] = $notifikasi["pesan"];
                $notifikasiarray[$count]['link'] = $notifikasi["link"];
                $count++;
            }
        }

        $data['success'] = "1";
        $data['count'] = $count;
        $data['data'] = $notifikasiarray;

        $this->setnotif($notifikasiarray);

        return $this->response->setJSON($data);
    }

    public function setnotif($data) {
        $return = array();
        $id_user = auth()->id();

        $notifikasipenerimamodel = new Notifikasipenerimamodel();
        foreach ($data as $notif) {
            $insert = [
                "id_notifikasi" => $notif['id_notifikasi'],
                "id_user" => $id_user,
                "is_read" => "0",
                "read_at" => date("Y-m-d H:i:s")
            ];
            $notifikasipenerimamodel->insert($insert);
        }
    }

    public function unread_count() {
        $data = array();
        $id = auth()->id();

        $notifikasiarray = array();
        $notifikasimodel = new Notifikasimodel();
        $notifikasibuilder = $notifikasimodel->builder("vnotifikasikombinasi");
        $notifikasibuilder->where("id_user",$id);
        $notifikasibuilder->where("is_read","0");
        $notifikasis = $notifikasibuilder->selectCount("id_notifikasi","jumlah_notif")->get()->getRow();
        $count = $notifikasis->jumlah_notif;

        $data['success'] = "1";
        $data['count'] = $count;

        return $this->response->setJSON($data);
    }

    public function unread_content() {
        $data = array();
        $id = auth()->id();

        $notifikasiarray = array();
        $notifikasimodel = new Notifikasimodel();
        $notifikasibuilder = $notifikasimodel->builder("vnotifikasikombinasi");
        $notifikasibuilder->where("id_user",$id);
        $notifikasibuilder->where("is_read","0");
        $notifikasis = $notifikasibuilder->get()->getResultArray();
        $count = 0;
        $content="";
        foreach($notifikasis as $notifikasi){
            $notifikasiarray[$count]['id_notifikasi'] = $notifikasi["id_notifikasi"];
            $notifikasiarray[$count]['judul'] = $notifikasi["judul"];
            $notifikasiarray[$count]['pesan'] = $notifikasi["pesan"];
            $notifikasiarray[$count]['link'] = $notifikasi["link"];
            $content .= "<a href='".base_url().$notifikasi['link']."' class='dropdown-item dropdown-item-notif' data-id='".$notifikasi['id_notifikasi_penerima']."' data-link='".base_url().$notifikasi['link']."'>
                <div><i class='bi bi-envelope me-2'></i>".$notifikasi['judul']."
                <span class='float-end text-secondary fs-7'>".$notifikasi["created_at"]."</span></div><div>".$notifikasi['pesan']."</div></a>";
            $count++;
        }

        $data['success'] = "1";
        $data['count'] = $count;
        $data['content'] = $content;

        return $this->response->setJSON($data);
    }

    public function set_notif_read() {
        $data = array();
        $id = auth()->id();

        $id_notifikasi = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);

        $update = [
            "is_read" => "1"
        ];

        $notifikasipenerimamodel = new Notifikasipenerimamodel();
        $notifikasipenerimamodel->update($id_notifikasi,$update);

        $data['success'] = "1";

        return $this->response->setJSON($data);
    }

    public function ajax_dt_blok($id_jalan){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];
        $DataModel = new Blokmodel();
        $extra = "(id_jalan ='".$id_jalan."')";
        return $DataModel->GetDT($data_post, $extra);
    }

    public function ajax_dt_blok2(){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];
        $DataModel = new Blokmodel();
        $extra = "";
        return $DataModel->GetDT($data_post, $extra);
    }

    public function view($id) {
        $data['user'] = $this->user->data;
        $tmodel = new Jalanmodel();
        $builder = $tmodel->builder();
        $data['data'] = $builder->where("id_jalan",$id)->get()->getRow();

        return view('admin/jalan/view',$data);
    }

    public function update()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);
        $request = [
            'kode' => $this->request->getPost('kode',FILTER_SANITIZE_ADD_SLASHES),
            'nama' => $this->request->getPost('nama',FILTER_SANITIZE_ADD_SLASHES),
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'updated_by' => $this->user->data->id_auth
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('kode', 'Kode', 'required|is_unique[jalan.kode,jalan.id_jalan,'.$id.']');
        $validation->setRule('nama', 'Nama', 'required|is_unique[jalan.nama,jalan.id_jalan,'.$id.']');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Jalanmodel();
            if ($tmodel->update($id,$request))
            {
                return $this->respond($data,200);
            }else{
                return $this->fail(["error" => "Database Error!"],400,null,'db');
            }
        }
    }

    public function delete()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);

        $tmodel = new Jalanmodel();
        if ($tmodel->delete($id))
        {
            return $this->respond($data,200);
        }else{
            return $this->fail(["error" => "Database Error!"],400,null,'db');
        }
    }

    public function add_blok($id_jalan) {
        $data['user'] = $this->user->data;
        
        $jalanmodel = new Jalanmodel();
        $jalanbuilder = $jalanmodel->builder("vjalan");
        $jalanbuilder->where("id_jalan",$id_jalan);
        $jalan = $jalanbuilder->get()->getRow();

        if(!$jalan){
            return view('admin/jalan',$data);
        }

        $data['jalan'] = $jalan;
        return view('admin/jalan/add_blok',$data);
    }

    public function add_save_blok()
    {
        $data = array();
        $data['status'] = 'success';

        $request = [
            'id_jalan' => $this->request->getPost('id_jalan',FILTER_SANITIZE_ADD_SLASHES),
            'kode' => $this->request->getPost('kode',FILTER_SANITIZE_ADD_SLASHES),
            'nama' => $this->request->getPost('nama',FILTER_SANITIZE_ADD_SLASHES),
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'created_by' => $this->user->data->id_auth,
            'updated_by' => $this->user->data->id_auth
        ];

        if(empty($request['id_jalan'])){
            return $this->fail(["error" => "ID Jalan Error!"],400,null,'db');
        }

        $validation = \Config\Services::validation();
        $validation->setRule('id_jalan', 'ID Jalan', 'required');
        $validation->setRule('kode', 'Kode', 'required');
        $validation->setRule('nama', 'Nama', 'required');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Blokmodel();
            $builder = $tmodel->builder();
            $builder->where("kode",$request['kode']);
            $builder->where("id_jalan",$request['id_jalan']);
            $bloks = $builder->selectCount("id_blok","jumlah_blok")->get()->getRow();
            if($bloks->jumlah_blok > 0){
                return $this->fail(["kode" => "Kode harus unik!"],400,null,'input');
            }

            if ($tmodel->insert($request, false))
            {
                return $this->respond($data,200);
            }else{
                return $this->fail(["error" => "Database Error!"],400,null,'db');
            }
        }
    }

    public function view_blok($id) {
        $data['user'] = $this->user->data;
        $tmodel = new Blokmodel();
        $builder = $tmodel->builder("vblok");
        $data['data'] = $builder->where("id_blok",$id)->get()->getRow();

        return view('admin/jalan/view_blok',$data);
    }

    public function update_blok()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);
        $request = [
            'kode' => $this->request->getPost('kode',FILTER_SANITIZE_ADD_SLASHES),
            'nama' => $this->request->getPost('nama',FILTER_SANITIZE_ADD_SLASHES),
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'updated_by' => $this->user->data->id_auth
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('kode', 'Kode', 'required');
        $validation->setRule('nama', 'Nama', 'required');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Blokmodel();
            $blok = $tmodel->find($id);
            if(!$blok){
                return $this->fail(["error" => "Database Error!"],400,null,'db');
            }
            $id_jalan = $blok["id_jalan"];

            $tmodel = new Blokmodel();
            $builder = $tmodel->builder();
            $builder->where("kode",$request['kode']);
            $builder->where("id_jalan",$id_jalan);
            $builder->where("id_blok !=",$id);
            $bloks = $builder->selectCount("id_blok","jumlah_blok")->get()->getRow();
            if($bloks->jumlah_blok > 0){
                return $this->fail(["kode" => "Kode harus unik!"],400,null,'input');
            }
            if ($tmodel->update($id,$request))
            {
                return $this->respond($data,200);
            }else{
                return $this->fail(["error" => "Database Error!"],400,null,'db');
            }
        }
    }

    public function delete_blok()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);

        $tmodel = new Blokmodel();
        if ($tmodel->delete($id))
        {
            return $this->respond($data,200);
        }else{
            return $this->fail(["error" => "Database Error!"],400,null,'db');
        }
    }
}
?>