<?php
namespace App\Controllers\Admin;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;
use CodeIgniter\Database\Exceptions\DatabaseException;

use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\Jenispembayaranmodel;
use App\Models\Transaksimodel;

class Jenispembayaran extends BaseController
{
    use ResponseTrait;

    private $user;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger) 
    {
        parent::initController($request, $response, $logger);
        $this->user = service("user_data");
    }

    private function check_access(){
        $user = service("user_data");
        if($user->data->group != 'admin'){
            return false;
        }else{
            return true;
        }
    }

    public function index(){
        $data['user'] = $this->user->data;
        return view('admin/jenispembayaran/index',$data);
    }

    public function ajax_dt(){
        $data_post = [
            'draw' => $this->request->getPost('draw'),
            'columns' => $this->request->getPost('columns'),
            'order' => $this->request->getPost('order'),
            'start' => $this->request->getPost('start'),
            'length' => $this->request->getPost('length'),
            'search' => $this->request->getPost('search'),
            'searchBuilder' => $this->request->getPost('searchBuilder'),
        ];
        $DataModel = new Jenispembayaranmodel();
        return $DataModel->GetDT($data_post,"");
    }

    public function add() {
        $data['user'] = $this->user->data;
        return view('admin/jenispembayaran/add',$data);
    }

    public function add_save()
    {
        $data = array();
        $data['status'] = 'success';

        $request = [
            'nama' => $this->request->getPost('nama',FILTER_SANITIZE_ADD_SLASHES),
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'created_by' => $this->user->data->id_auth,
            'updated_by' => $this->user->data->id_auth
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('nama', 'Nama', 'required|is_unique[jenis_pembayaran.nama]');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Jenispembayaranmodel();
            $tmodel->builder()->db()->transBegin();
            $tmodel->insert($request);
            if($tmodel->builder()->db()->transStatus() == false){
                $tmodel->builder()->db()->transRollback();
                return $this->fail(["error" => $tmodel->builder()->db()->transFailure],400,null,'db');
            }
            $tmodel->builder()->db()->transCommit();
            return $this->respond($data,200);
        }
    }

    public function view($id) {
        $data['user'] = $this->user->data;
        $tmodel = new Jenispembayaranmodel();
        $builder = $tmodel->builder();
        $data['data'] = $builder->where("id_jenis_pembayaran",$id)->get()->getRow();

        return view('admin/jenispembayaran/view',$data);
    }

    public function update()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);
        $request = [
            'nama' => $this->request->getPost('nama',FILTER_SANITIZE_ADD_SLASHES),
            'keterangan' => $this->request->getPost('keterangan',FILTER_SANITIZE_ADD_SLASHES),
            'updated_by' => $this->user->data->id_auth
        ];

        $validation = \Config\Services::validation();
        $validation->setRule('nama', 'Nama', 'required|is_unique[jenis_pembayaran.nama, jenis_pembayaran.id_jenis_pembayaran,'.$id.']');

        if (!$validation->run($request)) {
            return $this->fail($validation->getErrors(),400,null,'input');
        }else{
            $tmodel = new Jenispembayaranmodel();
            if ($tmodel->update($id,$request))
            {
                return $this->respond($data,200);
            }else{
                return $this->fail(["error" => "Database Error!"],400,null,'db');
            }
        }
    }

    public function delete()
    {
        $data = array();
        $data['status'] = 'success';

        $id = $this->request->getPost('id',FILTER_SANITIZE_ADD_SLASHES);

        $transaksimodel = new Transaksimodel();
        $transaksibuilder = $transaksimodel->builder();
        $transaksi = $transaksibuilder->where("id_jenis_pembayaran",$id)->countAllResults();
        if($transaksi > 0){
            return $this->fail(["error" => "Jenis Pembayaran sudah digunakan dan tidak dapat dihapus!"],400,null,'db');
        }
        
        $tmodel = new Jenispembayaranmodel();
        if ($tmodel->delete($id))
        {
            return $this->respond($data,200);
        }else{
            return $this->fail(["error" => "Database Error!"],400,null,'db');
        }
    }
}
?>