<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
//$routes->get('register', '\App\Controllers\Auth\RegisterController::registerView');
//$routes->get('addcutom', 'Addcutom::index');

$routes->get('/', 'Home::index');

$routes->group('', ['filter' => 'group:admin,operator,kolektor'], static function ($routes) {
    $routes->get('home', 'Admin\Home::index');

    $routes->group('jenis_kk', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('/', 'Admin\Jeniskk::index');
        $routes->get('add', 'Admin\Jeniskk::add');
        $routes->post('add_save', 'Admin\Jeniskk::add_save');
        $routes->get('view/(:any)', 'Admin\Jeniskk::view/$1');
        $routes->post('update', 'Admin\Jeniskk::update');
        $routes->post('delete', 'Admin\Jeniskk::delete');
    });

    $routes->group('jenis_kk', ['filter' => 'group:admin,operator,kolektor'], static function ($routes) {
        $routes->post('ajax_dt', 'Admin\Jeniskk::ajax_dt');
    });

    $routes->group('jalan', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('/', 'Admin\Jalan::index');
        $routes->get('add', 'Admin\Jalan::add');
        $routes->post('add_save', 'Admin\Jalan::add_save');
        $routes->get('view/(:any)', 'Admin\Jalan::view/$1');
        $routes->post('update', 'Admin\Jalan::update');
        $routes->post('delete', 'Admin\Jalan::delete');

        $routes->get('view_blok/(:any)', 'Admin\Jalan::view_blok/$1');
        $routes->get('add_blok/(:any)', 'Admin\Jalan::add_blok/$1');
        $routes->post('add_save_blok', 'Admin\Jalan::add_save_blok');
        $routes->post('update_blok', 'Admin\Jalan::update_blok');
        $routes->post('delete_blok', 'Admin\Jalan::delete_blok');
    });

    $routes->group('jalan', ['filter' => 'group:admin,operator,kolektor'], static function ($routes) {
        $routes->post('ajax_dt', 'Admin\Jalan::ajax_dt');
        $routes->post('ajax_dt_blok/(:any)', 'Admin\Jalan::ajax_dt_blok/$1');
        $routes->post('ajax_dt_blok2', 'Admin\Jalan::ajax_dt_blok2');
    });
    
    $routes->group('grup_transaksi', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('/', 'Admin\Gruptransaksi::index');
        $routes->get('add', 'Admin\Gruptransaksi::add');
        $routes->post('add_save', 'Admin\Gruptransaksi::add_save');
        $routes->get('view/(:any)', 'Admin\Gruptransaksi::view/$1');
        $routes->post('update', 'Admin\Gruptransaksi::update');
        $routes->post('delete', 'Admin\Gruptransaksi::delete');
    });

    $routes->group('grup_transaksi', ['filter' => 'group:admin,operator,kolektor'], static function ($routes) {
        $routes->post('ajax_dt', 'Admin\Gruptransaksi::ajax_dt');
    });

    $routes->group('jenis_pembayaran', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('/', 'Admin\Jenispembayaran::index');
        $routes->get('add', 'Admin\Jenispembayaran::add');
        $routes->post('add_save', 'Admin\Jenispembayaran::add_save');
        $routes->get('view/(:any)', 'Admin\Jenispembayaran::view/$1');
        $routes->post('update', 'Admin\Jenispembayaran::update');
        $routes->post('delete', 'Admin\Jenispembayaran::delete');
    });

    $routes->group('jenis_pembayaran', ['filter' => 'group:admin,operator,kolektor'], static function ($routes) {
        $routes->post('ajax_dt', 'Admin\Jenispembayaran::ajax_dt');
    });

    $routes->group('iuran', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('/', 'Admin\Iuran::index');
        $routes->post('ajax_dt', 'Admin\Iuran::ajax_dt');
        $routes->get('add', 'Admin\Iuran::add');
        $routes->post('add_save', 'Admin\Iuran::add_save');
        $routes->get('view/(:any)', 'Admin\Iuran::view/$1');
        $routes->post('update', 'Admin\Iuran::update');
        $routes->post('delete', 'Admin\Iuran::delete');
    });

    $routes->group('kk', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('/', 'Admin\Kk::index');
        $routes->get('add', 'Admin\Kk::add');
        $routes->post('add_save', 'Admin\Kk::add_save');
        $routes->get('view/(:any)', 'Admin\Kk::view/$1');
        $routes->post('update', 'Admin\Kk::update');
        $routes->post('delete', 'Admin\Kk::delete');
    });

    $routes->group('kk', ['filter' => 'group:admin,operator,kolektor'], static function ($routes) {
        $routes->post('ajax_dt', 'Admin\Kk::ajax_dt');

        $routes->get('cetak_kartu/(:any)', 'Admin\Kk::cetak_kartu/$1');
        $routes->post('countwarga', 'Admin\Kk::count_warga');
    });

    $routes->group('kolektor', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('/', 'Admin\Kolektor::index');
        $routes->get('add', 'Admin\Kolektor::add');
        $routes->post('add_save', 'Admin\Kolektor::add_save');
        $routes->get('view/(:any)', 'Admin\Kolektor::view/$1');
        $routes->post('update', 'Admin\Kolektor::update');
        $routes->post('delete', 'Admin\Kolektor::delete');
        $routes->get('cetak_kartu/(:any)', 'Admin\Kolektor::cetak_kartu/$1');
    });

    $routes->group('kolektor', ['filter' => 'group:admin,operator,kolektor'], static function ($routes) {
        $routes->post('ajax_dt', 'Admin\Kolektor::ajax_dt');
    });

    $routes->group('tarif', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('/', 'Admin\Tarif::index');
        $routes->get('detail/(:any)', 'Admin\Tarif::detail/$1');
        $routes->post('ajax_dt_kk', 'Admin\Tarif::ajax_dt_kk');
        $routes->post('ajax_dt/(:any)', 'Admin\Tarif::ajax_dt/$1');
        $routes->get('add/(:any)', 'Admin\Tarif::add/$1');
        $routes->post('add_save/(:any)', 'Admin\Tarif::add_save/$1');
        $routes->get('view/(:any)', 'Admin\Tarif::view/$1');
        $routes->post('update', 'Admin\Tarif::update');
        $routes->post('delete', 'Admin\Tarif::delete');
    });

    $routes->group('diskon', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('/', 'Admin\Diskon::index');
        $routes->get('detail/(:any)', 'Admin\Diskon::detail/$1');
        $routes->post('ajax_dt_kk', 'Admin\Diskon::ajax_dt_kk');
        $routes->post('ajax_dt/(:any)', 'Admin\Diskon::ajax_dt/$1');
        $routes->get('add/(:any)', 'Admin\Diskon::add/$1');
        $routes->post('add_save/(:any)', 'Admin\Diskon::add_save/$1');
        $routes->get('view/(:any)', 'Admin\Diskon::view/$1');
        $routes->post('update', 'Admin\Diskon::update');
        $routes->post('delete', 'Admin\Diskon::delete');
    });

    $routes->group('transaksi', ['filter' => 'group:admin, operator'], static function ($routes) {
        $routes->get('/', 'Admin\Transaksi::index');
        $routes->get('pending', 'Admin\Transaksi::pending');
        $routes->post('ajax_dt', 'Admin\Transaksi::ajax_dt');
        $routes->post('ajax_dt_pending', 'Admin\Transaksi::ajax_dt_pending');
        $routes->get('add', 'Admin\Transaksi::add');
        $routes->post('add_save', 'Admin\Transaksi::add_save');
        $routes->get('view/(:any)', 'Admin\Transaksi::view/$1');
        $routes->post('update', 'Admin\Transaksi::update');

        $routes->get('add_detail/(:any)/(:any)', 'Admin\Transaksi::add_detail/$1/$2');
        $routes->get('add_detail_simple/(:any)/(:any)', 'Admin\Transaksi::add_detail_simple/$1/$2');
        $routes->post('update_detail', 'Admin\Transaksi::update_detail');
        $routes->post('update_detail_simple', 'Admin\Transaksi::update_detail_simple');
        $routes->get('cancel_detail/(:any)/(:any)', 'Admin\Transaksi::cancel_detail/$1/$2');
        $routes->post('delete', 'Admin\Transaksi::delete');

        $routes->post('upload', 'Admin\Transaksi::upload');
        $routes->post('upload2', 'Admin\Transaksi::upload2');
        $routes->get('download_bukti_bayar/(:any)', 'Admin\Transaksi::download_bukti_bayar/$1');
        $routes->post('delete_bukti_bayar', 'Admin\Transaksi::delete_bukti_bayar');

        $routes->post('batal', 'Admin\Transaksi::batal');
        $routes->post('selesai', 'Admin\Transaksi::selesai');

        $routes->get('pelunasan_invoice', 'Admin\Transaksi::pelunasan_invoice');
        $routes->post('proses_pelunasan_invoice', 'Admin\Transaksi::proses_pelunasan_invoice');

        $routes->get('struk/(:any)', 'Admin\Transaksi::cetak_struk/$1');
        $routes->get('multistruk/(:any)', 'Admin\Transaksi::cetak_multi_struk/$1');
        $routes->get('strukkantor/(:any)/(:any)', 'Admin\Transaksi::cetak_multi_struk_kantor/$1/$2');
        $routes->get('strukkolektor/(:any)/(:any)', 'Admin\Transaksi::cetak_multi_struk_kolektor/$1/$2');
        $routes->get('buktibayar/(:any)/(:any)', 'Admin\Transaksi::cetak_bukti_bayar/$1/$2');

        $routes->get('pembatalan', 'Admin\Transaksi::pembatalan');
        $routes->post('ajax_dt_pembatalan', 'Admin\Transaksi::ajax_dt_pembatalan');
        $routes->get('view_pembatalan/(:any)', 'Admin\Transaksi::view_pembatalan/$1');

        $routes->get('warga', 'Admin\Transaksi::warga');
        $routes->post('ajax_dt_warga', 'Admin\Transaksi::ajax_dt_warga');
        $routes->get('warga_detail/(:any)', 'Admin\Transaksi::warga_detail/$1');
        $routes->post('ajax_dt_warga_tunggakan/(:any)', 'Admin\Transaksi::ajax_dt_warga_tunggakan/$1');
        $routes->post('ajax_dt_warga_penerimaan/(:any)', 'Admin\Transaksi::ajax_dt_warga_penerimaan/$1');
    });

    $routes->group('historytrans', ['filter' => 'group:admin, operator'], static function ($routes) {
        $routes->get('/', 'Admin\Historytrans::index');
        $routes->get('detail/(:any)', 'Admin\Historytrans::detail/$1');
        $routes->post('ajax_dt_kk', 'Admin\Historytrans::ajax_dt_kk');
        $routes->post('ajax_dt/(:any)', 'Admin\Historytrans::ajax_dt/$1');
        $routes->get('add/(:any)', 'Admin\Historytrans::add/$1');
        $routes->post('add_save/(:any)', 'Admin\Historytrans::add_save/$1');
        $routes->get('view/(:any)', 'Admin\Historytrans::view/$1');
        $routes->post('update', 'Admin\Historytrans::update');
        $routes->post('delete', 'Admin\Historytrans::delete');
    });

    $routes->group('invoice', ['filter' => 'group:admin,operator'], static function ($routes) {
        $routes->get('generate_invoice', 'Admin\Invoice::generate_invoice');
        $routes->post('proses_generate', 'Admin\Invoice::proses_generate');
    });

    $routes->group('invoice', ['filter' => 'group:admin,operator,kolektor'], static function ($routes) {
        $routes->get('open', 'Admin\Invoice::open');
        $routes->post('ajax_dt_open', 'Admin\Invoice::ajax_dt_open');
        $routes->get('cetak_invoice_open', 'Admin\Invoice::cetak_invoice_open');
        $routes->post('proses_cetak_invoice_open', 'Admin\Invoice::proses_cetak_invoice_open');

        $routes->get('cetak_invoice_closed', 'Admin\Invoice::cetak_invoice_closed');
        $routes->post('proses_cetak_invoice_closed', 'Admin\Invoice::proses_cetak_invoice_closed');

        $routes->get('cetak_invoice/(:any)', 'Admin\Invoice::cetak_invoice/$1');

        $routes->get('closed', 'Admin\Invoice::closed');
        $routes->post('ajax_dt_closed', 'Admin\Invoice::ajax_dt_closed');
        $routes->get('view_closed/(:any)', 'Admin\Invoice::view_closed/$1');
        $routes->get('cetak_struk/(:any)', 'Admin\Invoice::cetak_struk/$1');
        $routes->get('cetak_multistruk/(:any)', 'Admin\Invoice::cetak_struk/$1');
    });

    $routes->group('laporan', ['filter' => 'group:admin,operator'], static function ($routes) {
        $routes->get('harian/(:any)', 'Admin\Laporan::harian/$1');
        $routes->get('harian', 'Admin\Laporan::harian');
        $routes->post('ajax_dt_trans_harian/(:any)', 'Admin\Laporan::ajax_dt_trans_harian/$1');
        
        $routes->get('export_voucher_harian/(:any)', 'Admin\Laporan::export_voucher_harian/$1');
        $routes->get('export_penerimaan_harian/(:any)', 'Admin\Laporan::export_penerimaan_harian/$1');
        $routes->get('export_bukti_harian/(:any)', 'Admin\Laporan::export_bukti_harian/$1');
    });

    $routes->group('admin', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('/', 'Admin\Admin::index');
        $routes->post('ajax_dt', 'Admin\Admin::ajax_dt');
        $routes->get('add', 'Admin\Admin::add');
        $routes->post('add_save', 'Admin\Admin::add_save');
        $routes->get('view/(:any)', 'Admin\Admin::view/$1');
        $routes->post('update', 'Admin\Admin::update');
        $routes->post('delete', 'Admin\Admin::delete');
    });

    $routes->group('operator', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('/', 'Admin\Operator::index');
        $routes->post('ajax_dt', 'Admin\Operator::ajax_dt');
        $routes->get('add', 'Admin\Operator::add');
        $routes->post('add_save', 'Admin\Operator::add_save');
        $routes->get('view/(:any)', 'Admin\Operator::view/$1');
        $routes->post('update', 'Admin\Operator::update');
        $routes->post('delete', 'Admin\Operator::delete');
    });

    // $routes->group('kolektor', ['filter' => 'group:admin,operator'], static function ($routes) {
    //     $routes->get('/', 'Admin\Kolektor::index');
    //     $routes->post('ajax_dt', 'Admin\Kolektor::ajax_dt');
    //     $routes->get('add', 'Admin\Kolektor::add');
    //     $routes->post('add_save', 'Admin\Kolektor::add_save');
    //     $routes->get('view/(:any)', 'Admin\Kolektor::view/$1');
    //     $routes->post('update', 'Admin\Kolektor::update');
    //     $routes->post('delete', 'Admin\Kolektor::delete');
    // });

    $routes->group('exportlaporan', ['filter' => 'group:admin,operator,kolektor'], static function ($routes) {
        $routes->get('/', 'Admin\Exportlaporan::index');
        
        $routes->get('export_penerimaan', 'Admin\Exportlaporan::export_penerimaan');
        $routes->post('export_penerimaan_proses', 'Admin\Exportlaporan::export_penerimaan_proses');

        $routes->get('export_voucher_penerimaan', 'Admin\Exportlaporan::export_voucher_penerimaan');
        $routes->post('export_voucher_penerimaan_proses', 'Admin\Exportlaporan::export_voucher_penerimaan_proses');

        $routes->get('export_kwitansi', 'Admin\Exportlaporan::export_kwitansi');
        $routes->post('export_kwitansi_proses', 'Admin\Exportlaporan::export_kwitansi_proses');

        $routes->get('export_kwitansi_rekap', 'Admin\Exportlaporan::export_kwitansi_rekap');
        $routes->post('export_kwitansi_rekap_proses', 'Admin\Exportlaporan::export_kwitansi_rekap_proses');
    });

    $routes->group('notifikasi', ['filter' => 'group:admin,operator'], static function ($routes) {
        $routes->get('/', 'Admin\Notifikasi::index');
        
        $routes->get('unnotif', 'Admin\Notifikasi::unnotif');
        $routes->post('setnotif', 'Admin\Notifikasi::setnotif');
        $routes->get('unreadcount', 'Admin\Notifikasi::unread_count');
        $routes->get('unreadcontent', 'Admin\Notifikasi::unread_content');
        $routes->post('setnotifread', 'Admin\Notifikasi::set_notif_read');
        $routes->post('baca/(:any)', 'Admin\Notifikasi::baca/$1');
    });

    $routes->group('profile', ['filter' => 'group:admin'], static function ($routes) {
        $routes->get('/', 'Admin\Admin::profile');
        $routes->post('update', 'Admin\Admin::update_profile');
    });
});

$routes->group('operator', ['filter' => 'group:operator'], static function ($routes) {
    $routes->get('home', 'Operator\Home::index');

    $routes->group('profile', ['filter' => 'group:operator'], static function ($routes) {
        $routes->get('/', 'Operator\Operator::profile');
        $routes->post('update', 'Operator\Operator::update_profile');
    });
});

$routes->group('kolektor', ['filter' => 'group:kolektor'], static function ($routes) {
    $routes->get('home', 'Kolektor\Home::index');

    $routes->group('transaksi', ['filter' => 'group:kolektor'], static function ($routes) {
        $routes->get('/', 'Kolektor\Transaksi::index');
        $routes->post('ajax_dt', 'Kolektor\Transaksi::ajax_dt');
        $routes->get('add', 'Kolektor\Transaksi::add');
        $routes->post('add_save', 'Kolektor\Transaksi::add_save');
        $routes->get('view/(:any)', 'Kolektor\Transaksi::view/$1');
        $routes->post('update', 'Kolektor\Transaksi::update');

        $routes->get('add_detail/(:any)/(:any)', 'Kolektor\Transaksi::add_detail/$1/$2');
        $routes->post('update_detail', 'Kolektor\Transaksi::update_detail');
        $routes->get('cancel_detail/(:any)/(:any)', 'Kolektor\Transaksi::cancel_detail/$1/$2');
        $routes->post('delete', 'Kolektor\Transaksi::delete');

        $routes->post('upload', 'Kolektor\Transaksi::upload');
        $routes->post('upload2', 'Kolektor\Transaksi::upload2');
        $routes->get('download_bukti_bayar/(:any)', 'Kolektor\Transaksi::download_bukti_bayar/$1');
        $routes->post('delete_bukti_bayar', 'Kolektor\Transaksi::delete_bukti_bayar');

        $routes->post('batal', 'Kolektor\Transaksi::batal');
        $routes->post('selesai', 'Kolektor\Transaksi::selesai');
        $routes->get('struk/(:any)', 'Kolektor\Transaksi::cetak_struk/$1');
        $routes->get('multistruk/(:any)', 'Kolektor\Transaksi::cetak_multi_struk/$1');
        $routes->get('strukkantor/(:any)/(:any)', 'Kolektor\Transaksi::cetak_multi_struk_kantor/$1/$2');
        $routes->get('strukkolektor/(:any)/(:any)', 'Kolektor\Transaksi::cetak_multi_struk_kolektor/$1/$2');
        $routes->get('buktibayar/(:any)/(:any)', 'Kolektor\Transaksi::cetak_bukti_bayar/$1/$2');

        $routes->get('pembatalan', 'Kolektor\Transaksi::pembatalan');
        $routes->post('ajax_dt_pembatalan', 'Kolektor\Transaksi::ajax_dt_pembatalan');
        $routes->get('view_pembatalan/(:any)', 'Kolektor\Transaksi::view_pembatalan/$1');

        $routes->get('warga', 'Kolektor\Transaksi::warga');
        $routes->post('ajax_dt_warga', 'Kolektor\Transaksi::ajax_dt_warga');
        $routes->get('warga_detail/(:any)', 'Kolektor\Transaksi::warga_detail/$1');
        $routes->post('ajax_dt_warga_tunggakan/(:any)', 'Kolektor\Transaksi::ajax_dt_warga_tunggakan/$1');
        $routes->post('ajax_dt_warga_penerimaan/(:any)', 'Kolektor\Transaksi::ajax_dt_warga_penerimaan/$1');
    });

    $routes->group('profile', ['filter' => 'group:kolektor'], static function ($routes) {
        $routes->get('/', 'Kolektor\Kolektor::profile');
        $routes->post('update', 'Kolektor\Kolektor::update_profile');
    });
});

$routes->get('warga/(:any)', 'Warga\Home::index/$1');
$routes->get('vwarga/dashboard', 'Warga\Home::dashboard');
$routes->get('vwarga/pembayaran', 'Warga\Home::pembayaran');
$routes->post('vwarga/saveinvoice', 'Warga\Home::save_invoice');
$routes->get('vwarga/pembayaran_info', 'Warga\Home::pembayaran_info');
$routes->post('vwarga/saveinfo', 'Warga\Home::save_info');
$routes->get('vwarga/uploadbukti', 'Warga\Home::upload_bukti');
$routes->post('vwarga/uploadbuktiproses', 'Warga\Home::upload_bukti_proses');
$routes->get('vwarga/pembayaranselesai', 'Warga\Home::pembayaran_selesai');

$routes->get('vwarga/riwayat', 'Warga\Home::riwayat');
$routes->get('vwarga/riwayatdetail/(:any)', 'Warga\Home::riwayat_detail/$1');
$routes->get('vwarga/cetakstruk/(:any)', 'Warga\Home::cetak_struk/$1');

$routes->get('vwarga/struk/(:any)', 'Transaksi::cetak_struk/$1');
$routes->get('vwarga/cetak_invoice/(:any)', 'Invoice::cetak_invoice/$1');

service('auth')->routes($routes);
?>